/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.ecs.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.ecs.v2.model.NovaLink;
import com.huaweicloud.sdk.ecs.v2.model.NovaServerSecurityGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class NovaCreateServersResult {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="id")
    private String id;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="links")
    private List<NovaLink> links = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="security_groups")
    private List<NovaServerSecurityGroup> securityGroups = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="OS-DCF:diskConfig")
    private OsDCFDiskConfigEnum osDCFDiskConfig;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="reservation_id")
    private String reservationId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="adminPass")
    private String adminPass;

    public NovaCreateServersResult withId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public NovaCreateServersResult withLinks(List<NovaLink> links) {
        this.links = links;
        return this;
    }

    public NovaCreateServersResult addLinksItem(NovaLink linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<NovaLink>();
        }
        this.links.add(linksItem);
        return this;
    }

    public NovaCreateServersResult withLinks(Consumer<List<NovaLink>> linksSetter) {
        if (this.links == null) {
            this.links = new ArrayList<NovaLink>();
        }
        linksSetter.accept(this.links);
        return this;
    }

    public List<NovaLink> getLinks() {
        return this.links;
    }

    public void setLinks(List<NovaLink> links) {
        this.links = links;
    }

    public NovaCreateServersResult withSecurityGroups(List<NovaServerSecurityGroup> securityGroups) {
        this.securityGroups = securityGroups;
        return this;
    }

    public NovaCreateServersResult addSecurityGroupsItem(NovaServerSecurityGroup securityGroupsItem) {
        if (this.securityGroups == null) {
            this.securityGroups = new ArrayList<NovaServerSecurityGroup>();
        }
        this.securityGroups.add(securityGroupsItem);
        return this;
    }

    public NovaCreateServersResult withSecurityGroups(Consumer<List<NovaServerSecurityGroup>> securityGroupsSetter) {
        if (this.securityGroups == null) {
            this.securityGroups = new ArrayList<NovaServerSecurityGroup>();
        }
        securityGroupsSetter.accept(this.securityGroups);
        return this;
    }

    public List<NovaServerSecurityGroup> getSecurityGroups() {
        return this.securityGroups;
    }

    public void setSecurityGroups(List<NovaServerSecurityGroup> securityGroups) {
        this.securityGroups = securityGroups;
    }

    public NovaCreateServersResult withOsDCFDiskConfig(OsDCFDiskConfigEnum osDCFDiskConfig) {
        this.osDCFDiskConfig = osDCFDiskConfig;
        return this;
    }

    public OsDCFDiskConfigEnum getOsDCFDiskConfig() {
        return this.osDCFDiskConfig;
    }

    public void setOsDCFDiskConfig(OsDCFDiskConfigEnum osDCFDiskConfig) {
        this.osDCFDiskConfig = osDCFDiskConfig;
    }

    public NovaCreateServersResult withReservationId(String reservationId) {
        this.reservationId = reservationId;
        return this;
    }

    public String getReservationId() {
        return this.reservationId;
    }

    public void setReservationId(String reservationId) {
        this.reservationId = reservationId;
    }

    public NovaCreateServersResult withAdminPass(String adminPass) {
        this.adminPass = adminPass;
        return this;
    }

    public String getAdminPass() {
        return this.adminPass;
    }

    public void setAdminPass(String adminPass) {
        this.adminPass = adminPass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NovaCreateServersResult novaCreateServersResult = (NovaCreateServersResult)o;
        return Objects.equals(this.id, novaCreateServersResult.id) && Objects.equals(this.links, novaCreateServersResult.links) && Objects.equals(this.securityGroups, novaCreateServersResult.securityGroups) && Objects.equals(this.osDCFDiskConfig, novaCreateServersResult.osDCFDiskConfig) && Objects.equals(this.reservationId, novaCreateServersResult.reservationId) && Objects.equals(this.adminPass, novaCreateServersResult.adminPass);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.links, this.securityGroups, this.osDCFDiskConfig, this.reservationId, this.adminPass);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NovaCreateServersResult {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    securityGroups: ").append(this.toIndentedString(this.securityGroups)).append("\n");
        sb.append("    osDCFDiskConfig: ").append(this.toIndentedString(this.osDCFDiskConfig)).append("\n");
        sb.append("    reservationId: ").append(this.toIndentedString(this.reservationId)).append("\n");
        sb.append("    adminPass: ").append(this.toIndentedString(this.adminPass)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class OsDCFDiskConfigEnum {
        public static final OsDCFDiskConfigEnum MANUAL = new OsDCFDiskConfigEnum("MANUAL");
        public static final OsDCFDiskConfigEnum AUTO = new OsDCFDiskConfigEnum("AUTO");
        private static final Map<String, OsDCFDiskConfigEnum> STATIC_FIELDS = OsDCFDiskConfigEnum.createStaticFields();
        private String value;

        private static Map<String, OsDCFDiskConfigEnum> createStaticFields() {
            HashMap<String, OsDCFDiskConfigEnum> map = new HashMap<String, OsDCFDiskConfigEnum>();
            map.put("MANUAL", MANUAL);
            map.put("AUTO", AUTO);
            return Collections.unmodifiableMap(map);
        }

        OsDCFDiskConfigEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return String.valueOf(this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OsDCFDiskConfigEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            OsDCFDiskConfigEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new OsDCFDiskConfigEnum(value);
            }
            return result;
        }

        public static OsDCFDiskConfigEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            OsDCFDiskConfigEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof OsDCFDiskConfigEnum) {
                return this.value.equals(((OsDCFDiskConfigEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

