/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.cdn.v1.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.huaweicloud.sdk.cdn.v1.model.CompressRequest;
import com.huaweicloud.sdk.cdn.v1.model.Rules;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class CacheConfigRequest {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="ignore_url_parameter")
    private Boolean ignoreUrlParameter;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="follow_origin")
    private Boolean followOrigin;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="compress")
    private CompressRequest compress;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="rules")
    private List<Rules> rules = null;

    public CacheConfigRequest withIgnoreUrlParameter(Boolean ignoreUrlParameter) {
        this.ignoreUrlParameter = ignoreUrlParameter;
        return this;
    }

    public Boolean getIgnoreUrlParameter() {
        return this.ignoreUrlParameter;
    }

    public void setIgnoreUrlParameter(Boolean ignoreUrlParameter) {
        this.ignoreUrlParameter = ignoreUrlParameter;
    }

    public CacheConfigRequest withFollowOrigin(Boolean followOrigin) {
        this.followOrigin = followOrigin;
        return this;
    }

    public Boolean getFollowOrigin() {
        return this.followOrigin;
    }

    public void setFollowOrigin(Boolean followOrigin) {
        this.followOrigin = followOrigin;
    }

    public CacheConfigRequest withCompress(CompressRequest compress) {
        this.compress = compress;
        return this;
    }

    public CacheConfigRequest withCompress(Consumer<CompressRequest> compressSetter) {
        if (this.compress == null) {
            this.compress = new CompressRequest();
            compressSetter.accept(this.compress);
        }
        return this;
    }

    public CompressRequest getCompress() {
        return this.compress;
    }

    public void setCompress(CompressRequest compress) {
        this.compress = compress;
    }

    public CacheConfigRequest withRules(List<Rules> rules) {
        this.rules = rules;
        return this;
    }

    public CacheConfigRequest addRulesItem(Rules rulesItem) {
        if (this.rules == null) {
            this.rules = new ArrayList<Rules>();
        }
        this.rules.add(rulesItem);
        return this;
    }

    public CacheConfigRequest withRules(Consumer<List<Rules>> rulesSetter) {
        if (this.rules == null) {
            this.rules = new ArrayList<Rules>();
        }
        rulesSetter.accept(this.rules);
        return this;
    }

    public List<Rules> getRules() {
        return this.rules;
    }

    public void setRules(List<Rules> rules) {
        this.rules = rules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheConfigRequest cacheConfigRequest = (CacheConfigRequest)o;
        return Objects.equals(this.ignoreUrlParameter, cacheConfigRequest.ignoreUrlParameter) && Objects.equals(this.followOrigin, cacheConfigRequest.followOrigin) && Objects.equals(this.compress, cacheConfigRequest.compress) && Objects.equals(this.rules, cacheConfigRequest.rules);
    }

    public int hashCode() {
        return Objects.hash(this.ignoreUrlParameter, this.followOrigin, this.compress, this.rules);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CacheConfigRequest {\n");
        sb.append("    ignoreUrlParameter: ").append(this.toIndentedString(this.ignoreUrlParameter)).append("\n");
        sb.append("    followOrigin: ").append(this.toIndentedString(this.followOrigin)).append("\n");
        sb.append("    compress: ").append(this.toIndentedString(this.compress)).append("\n");
        sb.append("    rules: ").append(this.toIndentedString(this.rules)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

