/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.xml;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.xml.ObsSimpleXMLBuilder;
import com.obs.services.model.Qos.QosConfiguration;
import java.util.Optional;

public class QosConfigurationXMLBuilder
extends ObsSimpleXMLBuilder {
    private static final ILogger log = LoggerBuilder.getLogger("com.obs.services.ObsClient");

    public String buildXML(QosConfiguration qosConfiguration) throws ObsException {
        this.checkQosConfiguration(qosConfiguration);
        this.startElement("PutBucketQoSRequestBody");
        this.startElement("QoSConfiguration");
        qosConfiguration.getRules().forEach(rule -> {
            this.startElement("QoSRule");
            Optional.ofNullable(rule.getNetworkType()).ifPresent(nt -> {
                this.startElement("NetworkType");
                this.append(nt.getCode());
                this.endElement("NetworkType");
            });
            Optional.of(rule.getConcurrentRequestLimit()).ifPresent(crl -> {
                this.startElement("ConcurrentRequestLimit");
                this.append(String.valueOf(crl));
                this.endElement("ConcurrentRequestLimit");
            });
            Optional.ofNullable(rule.getQpsLimit()).ifPresent(qpsLimit -> {
                this.startElement("QpsLimit");
                Optional.of(qpsLimit.getQpsGetLimit()).ifPresent(getQps -> {
                    this.startElement("Get");
                    this.append(String.valueOf(getQps));
                    this.endElement("Get");
                });
                Optional.of(qpsLimit.getQpsPutPostDeleteLimit()).ifPresent(putPostDeleteQps -> {
                    this.startElement("PutPostDelete");
                    this.append(String.valueOf(putPostDeleteQps));
                    this.endElement("PutPostDelete");
                });
                Optional.of(qpsLimit.getQpsListLimit()).ifPresent(listQps -> {
                    this.startElement("List");
                    this.append(String.valueOf(listQps));
                    this.endElement("List");
                });
                Optional.of(qpsLimit.getQpsTotalLimit()).ifPresent(totalQps -> {
                    this.startElement("Total");
                    this.append(String.valueOf(totalQps));
                    this.endElement("Total");
                });
                this.endElement("QpsLimit");
            });
            Optional.ofNullable(rule.getBpsLimit()).ifPresent(bpsLimit -> {
                this.startElement("BpsLimit");
                Optional.of(bpsLimit.getBpsGetLimit()).ifPresent(getBps -> {
                    this.startElement("Get");
                    this.append(String.valueOf(getBps));
                    this.endElement("Get");
                });
                Optional.of(bpsLimit.getBpsPutPostLimit()).ifPresent(putPostBps -> {
                    this.startElement("PutPost");
                    this.append(String.valueOf(putPostBps));
                    this.endElement("PutPost");
                });
                Optional.of(bpsLimit.getBpsTotalLimit()).ifPresent(totalBps -> {
                    this.startElement("Total");
                    this.append(String.valueOf(totalBps));
                    this.endElement("Total");
                });
                this.endElement("BpsLimit");
            });
            this.endElement("QoSRule");
        });
        this.endElement("QoSConfiguration");
        this.endElement("PutBucketQoSRequestBody");
        return this.getXmlBuilder().toString();
    }

    protected void checkQosConfiguration(QosConfiguration qosConfiguration) {
        if (qosConfiguration == null) {
            String errorMessage = "qosConfiguration is null, failed to build request XML!";
            log.error(errorMessage);
            throw new ObsException(errorMessage);
        }
        if (qosConfiguration.getRules() == null || qosConfiguration.getRules().isEmpty()) {
            String errorMessage = "qosConfiguration's QosRuleList is null or empty, failed to build request XML!";
            log.error(errorMessage);
            throw new ObsException(errorMessage);
        }
    }
}

