/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.ml.common.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicYuvToRGB;
import android.renderscript.Type;
import java.util.Locale;

public class NV21ToBitmapConverter1 {
    private RenderScript renderScript;
    private ScriptIntrinsicYuvToRGB yuvToRgbIntrinsic;
    private Type.Builder yuvType;
    private Type.Builder rgbaType;
    private Allocation in;
    private Allocation out;
    private Context applicationContext;
    private int width = -1;
    private int height = -1;
    private int length = -1;

    public NV21ToBitmapConverter1(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        Context applicationContext = context.getApplicationContext();
        this.applicationContext = applicationContext == null ? context : applicationContext;
        this.renderScript = RenderScript.create((Context)this.applicationContext);
        if (this.renderScript != null) {
            this.yuvToRgbIntrinsic = ScriptIntrinsicYuvToRGB.create((RenderScript)this.renderScript, (Element)Element.U8_4((RenderScript)this.renderScript));
        }
    }

    public Context getApplicationContext() {
        if (this.applicationContext == null) {
            throw new IllegalStateException("initial must be called first");
        }
        return this.applicationContext;
    }

    public Bitmap convertYUVtoRGB(byte[] yuvData, int width, int height) {
        if (this.yuvType == null) {
            this.yuvType = new Type.Builder(this.renderScript, Element.U8((RenderScript)this.renderScript)).setX(yuvData.length);
            this.in = Allocation.createTyped((RenderScript)this.renderScript, (Type)this.yuvType.create(), (int)1);
            this.rgbaType = new Type.Builder(this.renderScript, Element.RGBA_8888((RenderScript)this.renderScript)).setX(width).setY(height);
            this.out = Allocation.createTyped((RenderScript)this.renderScript, (Type)this.rgbaType.create(), (int)1);
        }
        this.in.copyFrom(yuvData);
        if (this.yuvToRgbIntrinsic != null) {
            this.yuvToRgbIntrinsic.setInput(this.in);
            this.yuvToRgbIntrinsic.forEach(this.out);
        }
        Bitmap result = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.out.copyTo(result);
        return result;
    }

    public Matrix getTransformationMatrix(int srcWidth, int srcHeight, int dstWidth, int dstHeight, int applyRotation, boolean flipHorizontal, boolean flipVertical, boolean maintainAspectRatio) {
        int flipVerticalFactor;
        Matrix matrix = new Matrix();
        if (applyRotation != 0) {
            if (applyRotation % 90 != 0) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Rotation of %d", applyRotation));
            }
            matrix.postTranslate((float)(-srcWidth) / 2.0f, (float)(-srcHeight) / 2.0f);
            matrix.postRotate((float)applyRotation);
        }
        boolean transpose = (Math.abs(applyRotation) + 90) % 180 == 0;
        int inWidth = transpose ? srcHeight : srcWidth;
        int inHeight = transpose ? srcWidth : srcHeight;
        int flipHorizontalFactor = flipHorizontal ? -1 : 1;
        int n = flipVerticalFactor = flipVertical ? -1 : 1;
        if (inWidth != dstWidth || inHeight != dstHeight) {
            float scaleFactorX = (float)(flipHorizontalFactor * dstWidth) / (float)inWidth;
            float scaleFactorY = (float)(flipVerticalFactor * dstHeight) / (float)inHeight;
            if (maintainAspectRatio) {
                float scaleFactor = Math.max(Math.abs(scaleFactorX), Math.abs(scaleFactorY));
                matrix.postScale(scaleFactor, scaleFactor);
            } else {
                matrix.postScale(scaleFactorX, scaleFactorY);
            }
        }
        if (applyRotation != 0) {
            float dx = (float)dstWidth / 2.0f;
            float dy = (float)dstHeight / 2.0f;
            matrix.postTranslate(dx, dy);
            matrix.postScale((float)flipHorizontalFactor, (float)flipVerticalFactor, dx, dy);
        }
        return matrix;
    }

    public Bitmap convert(byte[] bytes, int srcWidth, int srcHeight, int destWidth, int destHeight, int rotation, boolean flipHorizontal, boolean flipVertical, boolean maintainAspectRatio) {
        this.recreateIfNeed(bytes, srcWidth, srcHeight, rotation);
        Bitmap target = Bitmap.createBitmap((int)destWidth, (int)destHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(target);
        Bitmap source = this.convertYUVtoRGB(bytes, srcWidth, srcHeight);
        Matrix matrix = this.getTransformationMatrix(srcWidth, srcHeight, destWidth, destHeight, rotation, flipHorizontal, flipVertical, maintainAspectRatio);
        canvas.drawBitmap(source, matrix, null);
        return target;
    }

    public Bitmap convert(byte[] bytes, int srcWidth, int srcHeight, int destWidth, int destHeight, int rotation) {
        return this.convert(bytes, srcWidth, srcHeight, destWidth, destHeight, rotation, false, false, false);
    }

    private void recreateIfNeed(byte[] bytes, int srcWidth, int srcHeight, int rotation) {
        if (this.width == srcWidth && this.height == srcHeight && this.length == bytes.length) {
            return;
        }
        this.width = srcWidth;
        this.height = srcHeight;
        this.length = bytes.length;
        this.yuvType = null;
        this.rgbaType = null;
    }
}

