/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.ml.common.utils;

import android.content.Context;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.huawei.hms.ml.common.utils.SmartLog;
import java.lang.reflect.Method;
import java.util.Locale;

public class CountryCodeBean {
    private static final String TAG = CountryCodeBean.class.getSimpleName();
    private static final String VENDORCOUNTRY_SYSTEMPROP = "ro.hw.country";
    private static final String HONOR_VENDORCOUNTRY_SYSTEMPROP = "msc.sys.country";
    private static final String LOCALE_COUNTRYSYSTEMPROP = "ro.product.locale.region";
    private static final String SPECIAL_COUNTRYCODE_EU = "eu";
    private static final String SPECIAL_COUNTRYCODE_LA = "la";
    private static final String SPECIAL_COUNTRYCODE_CN = "cn";
    private static final String ANDRIOD_SYSTEMPROP = "android.os.SystemProperties";
    private static final int COUNTRYCODE_SIZE = 2;
    private static final String VENDOR_COUNTRY = "VENDOR_COUNTRY";
    private static final String SIM_COUNTRY = "SIM_COUNTRY";
    private static final String NETWORK_COUNTRY = "NETWORK_COUNTRY";
    private static final String LOCALE_INFO = "LOCALE_INFO";
    private static final String UNKNOWN = "UNKNOWN";
    private String countrySource = "UNKNOWN";
    private String countryCode = "UNKNOWN";

    public CountryCodeBean(Context context, boolean enableNetwork) {
        this.init(context, enableNetwork);
        this.countryCode = this.countryCode.toUpperCase(Locale.ENGLISH);
    }

    public String getCountrySource() {
        return this.countrySource;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    private void init(Context context, boolean enableNetwork) {
        if (context == null) {
            throw new NullPointerException("context must be not null.Please provide app's Context");
        }
        try {
            this.getVendorCountryCode();
            if (this.isCodeValidate()) {
                SmartLog.d(TAG, "getCountryCode get country code from {%s}", VENDOR_COUNTRY);
                return;
            }
            this.getSimCountryCode(context, enableNetwork);
            if (this.isCodeValidate()) {
                SmartLog.d(TAG, "getCountryCode get country code from {%s}", SIM_COUNTRY);
                return;
            }
            this.getLocaleCountryCode();
            if (this.isCodeValidate()) {
                SmartLog.d(TAG, "getCountryCode get country code from {%s}", LOCALE_INFO);
            }
        }
        catch (Exception e) {
            SmartLog.w(TAG, "get CountryCode error");
        }
    }

    private boolean isCodeValidate() {
        return !UNKNOWN.equals(this.countryCode);
    }

    private void checkCodeLenth() {
        if (this.countryCode == null || this.countryCode.length() != 2) {
            this.countryCode = UNKNOWN;
            this.countrySource = UNKNOWN;
        }
    }

    private void getVendorCountryCode() {
        this.countrySource = VENDOR_COUNTRY;
        String brand = Build.BRAND;
        this.countryCode = "HONOR".equals(brand) ? CountryCodeBean.getProperty("get", HONOR_VENDORCOUNTRY_SYSTEMPROP, ANDRIOD_SYSTEMPROP, UNKNOWN) : CountryCodeBean.getProperty("get", VENDORCOUNTRY_SYSTEMPROP, ANDRIOD_SYSTEMPROP, UNKNOWN);
        SmartLog.e(TAG, "getVendorCountry=" + this.countryCode);
        if (SPECIAL_COUNTRYCODE_EU.equalsIgnoreCase(this.countryCode) || SPECIAL_COUNTRYCODE_LA.equalsIgnoreCase(this.countryCode)) {
            SmartLog.e(TAG, "getVendorCountry equals eu or la ,not reliable");
            this.countryCode = UNKNOWN;
            this.countrySource = UNKNOWN;
        } else {
            this.checkCodeLenth();
        }
    }

    private void getSimCountryCode(Context context, boolean enableNetwork) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getApplicationContext().getSystemService("phone");
        if (telephonyManager != null) {
            if (enableNetwork && telephonyManager.getPhoneType() != 2) {
                this.countryCode = telephonyManager.getNetworkCountryIso();
                this.countrySource = NETWORK_COUNTRY;
                SmartLog.e(TAG, "getSimCountryCode by enableNetwork, countryCode=" + this.countryCode);
            } else {
                this.countryCode = telephonyManager.getSimCountryIso();
                this.countrySource = SIM_COUNTRY;
                SmartLog.e(TAG, "getSimCountryCode by not enableNetwork, countryCode=" + this.countryCode);
            }
        }
        this.checkCodeLenth();
    }

    private void getLocaleCountryCode() {
        this.countryCode = CountryCodeBean.getProperty("get", LOCALE_COUNTRYSYSTEMPROP, ANDRIOD_SYSTEMPROP, UNKNOWN);
        this.countrySource = LOCALE_INFO;
        SmartLog.e(TAG, "getLocaleCountryCode=" + this.countryCode);
        if (!SPECIAL_COUNTRYCODE_CN.equalsIgnoreCase(this.countryCode)) {
            SmartLog.e(TAG, "getLocaleCountryCode from system language is not reliable.");
            this.countryCode = UNKNOWN;
            this.countrySource = UNKNOWN;
        }
    }

    private static String getProperty(String var0, String var1, String var2, String var3) {
        if (!(TextUtils.isEmpty((CharSequence)var0) || TextUtils.isEmpty((CharSequence)var1) || TextUtils.isEmpty((CharSequence)var2))) {
            try {
                Class<?> var5 = Class.forName(var2);
                Method var6 = var5.getMethod(var0, String.class, String.class);
                return (String)var6.invoke(var5, var1, var3);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception var7) {
                SmartLog.e(TAG, "getProperty catch exception: ", var7);
                return var3;
            }
        }
        SmartLog.w(TAG, "reflect class for method has exception.");
        return var3;
    }
}

