/*
 * Decompiled with CFR 0.152.
 */
package com.highgo.jdbc.core;

import com.highgo.jdbc.core.ServerVersion;
import com.highgo.jdbc.util.GT;
import com.highgo.jdbc.util.HostSpec;
import com.highgo.jdbc.util.PSQLException;
import com.highgo.jdbc.util.PSQLState;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Utils {
    public static String toHexString(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 2);
        for (byte element : data) {
            sb.append(Integer.toHexString(element >> 4 & 0xF));
            sb.append(Integer.toHexString(element & 0xF));
        }
        return sb.toString();
    }

    public static StringBuilder escapeLiteral(@Nullable StringBuilder sbuf, String value, boolean standardConformingStrings) throws SQLException {
        if (sbuf == null) {
            sbuf = new StringBuilder((value.length() + 10) / 10 * 11);
        }
        Utils.doAppendEscapedLiteral(sbuf, value, standardConformingStrings);
        return sbuf;
    }

    private static void doAppendEscapedLiteral(Appendable sbuf, String value, boolean standardConformingStrings) throws SQLException {
        try {
            if (standardConformingStrings) {
                for (int i = 0; i < value.length(); ++i) {
                    char ch = value.charAt(i);
                    if (ch == '\u0000') {
                        throw new PSQLException(GT.tr("Zero bytes may not occur in string parameters.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
                    }
                    if (ch == '\'') {
                        sbuf.append('\'');
                    }
                    sbuf.append(ch);
                }
            } else {
                for (int i = 0; i < value.length(); ++i) {
                    char ch = value.charAt(i);
                    if (ch == '\u0000') {
                        throw new PSQLException(GT.tr("Zero bytes may not occur in string parameters.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
                    }
                    if (ch == '\\' || ch == '\'') {
                        sbuf.append(ch);
                    }
                    sbuf.append(ch);
                }
            }
        }
        catch (IOException e) {
            throw new PSQLException(GT.tr("No IOException expected from StringBuffer or StringBuilder", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)e);
        }
    }

    public static StringBuilder escapeIdentifier(@Nullable StringBuilder sbuf, String value) throws SQLException {
        if (sbuf == null) {
            sbuf = new StringBuilder(2 + (value.length() + 10) / 10 * 11);
        }
        Utils.doAppendEscapedIdentifier(sbuf, value);
        return sbuf;
    }

    private static void doAppendEscapedIdentifier(Appendable sbuf, String value) throws SQLException {
        try {
            sbuf.append('\"');
            for (int i = 0; i < value.length(); ++i) {
                char ch = value.charAt(i);
                if (ch == '\u0000') {
                    throw new PSQLException(GT.tr("Zero bytes may not occur in identifiers.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
                }
                if (ch == '\"') {
                    sbuf.append(ch);
                }
                sbuf.append(ch);
            }
            sbuf.append('\"');
        }
        catch (IOException e) {
            throw new PSQLException(GT.tr("No IOException expected from StringBuffer or StringBuilder", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)e);
        }
    }

    @Deprecated
    public static int parseServerVersionStr(@Nullable String serverVersion) throws NumberFormatException {
        return ServerVersion.parseServerVersionStr(serverVersion);
    }

    public static String jointID(HostSpec hostSpec) {
        return hostSpec.getHost() + ":" + hostSpec.getPort();
    }

    public static String jointID(String host, String port) {
        return host + ":" + port;
    }

    public static boolean isHump(String str) {
        for (int i = 1; i < str.length(); ++i) {
            char tempPrevChar = str.charAt(i - 1);
            if (!Utils.isSimpleLetter(tempPrevChar)) continue;
            char prevChar = tempPrevChar;
            char tempCurrentChar = str.charAt(i);
            if (!Utils.isSimpleLetter(tempCurrentChar)) continue;
            char currentChar = str.charAt(i);
            if (Character.isLowerCase(prevChar) == Character.isLowerCase(currentChar)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsSpecialCharacters(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (Utils.isSimpleLetter(ch) || Utils.isNumber(ch) || ch == '_') continue;
            return true;
        }
        return false;
    }

    public static boolean isSimpleLetter(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
    }

    public static boolean isNumber(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static String getSingleMac() throws UnknownHostException, SocketException {
        return Utils.getSingleMac(InetAddress.getLocalHost());
    }

    public static String getSingleMac(InetAddress address) throws SocketException {
        NetworkInterface ni = NetworkInterface.getByInetAddress(address);
        byte[] mac = ni.getHardwareAddress();
        if (mac == null) {
            return null;
        }
        String sIP = address.getHostAddress();
        String sMac = "";
        Formatter formatter = new Formatter();
        for (int i = 0; i < mac.length; ++i) {
            sMac = formatter.format(Locale.getDefault(), "%02X%s", mac[i], "").toString();
        }
        return sMac;
    }

    public static List<String> getMultiMac() {
        ArrayList<String> macs = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface iface = en.nextElement();
                List<InterfaceAddress> addrs = iface.getInterfaceAddresses();
                for (InterfaceAddress addr : addrs) {
                    String mac = Utils.getSingleMac(addr.getAddress());
                    if (mac == null || macs.contains(mac)) continue;
                    macs.add(mac);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return macs;
    }

    public static final int getProcessID() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        return Integer.valueOf(runtimeMXBean.getName().split("@")[0]);
    }

    public static final int getLinuxUserID() throws IOException {
        String osName = System.getProperty("os.name");
        if (!Pattern.matches("Linux.*", osName)) {
            return -2;
        }
        String username = System.getProperty("user.name");
        String command = "id -u " + username;
        Process child = Runtime.getRuntime().exec(command);
        InputStream in = child.getInputStream();
        int c = in.read();
        return c;
    }

    public static final byte[] encode(String sql, String encodingName) throws PSQLException {
        try {
            return sql.getBytes(encodingName);
        }
        catch (UnsupportedEncodingException ex) {
            throw new PSQLException(ex.getLocalizedMessage(), PSQLState.UNKNOWN_STATE, (Throwable)ex);
        }
    }
}

