/*
 * Decompiled with CFR 0.152.
 */
package com.highgo.jdbc.bulkload;

import com.highgo.jdbc.bulkload.BulkloadFileFolderHandler;
import com.highgo.jdbc.bulkload.BulkloadIn;
import com.highgo.jdbc.bulkload.BulkloadOperation;
import com.highgo.jdbc.core.BaseConnection;
import com.highgo.jdbc.core.Encoding;
import com.highgo.jdbc.core.QueryExecutor;
import com.highgo.jdbc.jdbc.BulkloadResultHandler;
import com.highgo.jdbc.jdbc.PgStatement;
import com.highgo.jdbc.util.GT;
import com.highgo.jdbc.util.PSQLException;
import com.highgo.jdbc.util.PSQLState;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

public class BulkloadManager {
    static final int DEFAULT_BUFFER_SIZE = 65536;
    private final Encoding encoding;
    private final QueryExecutor queryExecutor;
    private final BaseConnection connection;
    private final String bulkloadCtlFile;
    private Properties bulkloadInfo;
    private BulkloadResultHandler handler;
    private final BulkloadFileFolderHandler fileFolderHandler;

    public BulkloadManager(BaseConnection connection) throws SQLException {
        this.encoding = connection.getEncoding();
        this.queryExecutor = connection.getQueryExecutor();
        this.connection = connection;
        this.bulkloadCtlFile = connection.getBulkloadCtlFile();
        this.handler = new BulkloadResultHandler((PgStatement)connection.createStatement());
        this.fileFolderHandler = new BulkloadFileFolderHandler(this);
        if (this.bulkloadCtlFile != null) {
            this.loadBulkloadCtlFile();
        }
    }

    public BulkloadIn bulkloadIn(String sql) throws SQLException {
        BulkloadOperation op = this.queryExecutor.startBulkload(this.handler, sql, false, this.initFlags());
        if (op == null || op instanceof BulkloadIn) {
            return (BulkloadIn)op;
        }
        op.cancelBulkload();
        throw new PSQLException(GT.tr("Requested bulkloadIn but got {0}", op.getClass().getName()), PSQLState.WRONG_OBJECT_TYPE);
    }

    private BulkloadIn bulkloadInGetOperation(int flags) throws SQLException {
        BulkloadOperation op = this.queryExecutor.startBulkload(this.handler, this.getBulkloadStartSQL(), false, flags);
        if (op == null || op instanceof BulkloadIn) {
            return (BulkloadIn)op;
        }
        op.cancelBulkload();
        throw new PSQLException(GT.tr("Requested bulkloadIn but got {0}", op.getClass().getName()), PSQLState.WRONG_OBJECT_TYPE);
    }

    public ResultSet bulkloadIn() throws SQLException {
        String inputValue = this.getBulkloadInfo().getProperty("INPUT");
        if ("stdin".equals(inputValue.toLowerCase())) {
            throw new PSQLException("For the parameter 'INPUT' of pg_bulkload, the binary file needs to be input when the value is 'STDIN'. use bulkloadIn(InputStream) or other functions.", PSQLState.INVALID_PARAMETER_VALUE);
        }
        BulkloadIn op = this.bulkloadInGetOperation(this.initFlags());
        return this.handler.getResults().getResultSet();
    }

    public ResultSet bulkloadIn(InputStream from) throws SQLException, IOException {
        return this.bulkloadIn(from, 65536);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet bulkloadIn(InputStream from, int bufferSize) throws SQLException, IOException {
        this.checkParams();
        byte[] buf = new byte[bufferSize];
        int flags = this.initFlags();
        BulkloadIn cp = this.bulkloadInGetOperation(flags);
        if ((flags & 1) == 0) {
            return this.handler.getResults().getResultSet();
        }
        try {
            int len;
            while ((len = from.read(buf)) >= 0) {
                cp.writeToBulkload(buf, 0, len);
            }
            ResultSet rs = cp.endBulkload();
            this.connection.execSQLUpdate("commit");
            ResultSet resultSet = rs;
            return resultSet;
        }
        finally {
            if (cp.isActive()) {
                cp.cancelBulkload();
            }
        }
    }

    public ResultSet bulkloadIn(String folderPath, Pattern fileNamePattern) throws SQLException, FileNotFoundException, IOException {
        return this.bulkloadIn(this.fileFolderHandler.getFilesFromFolder(folderPath, fileNamePattern));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet bulkloadIn(File[] files) throws SQLException, FileNotFoundException, IOException {
        int flags = this.initFlags();
        BulkloadIn cp = this.bulkloadInGetOperation(flags);
        if ((flags & 1) == 0) {
            return this.handler.getResults().getResultSet();
        }
        FileInputStream fis = null;
        try {
            byte[] buf = new byte[65536];
            for (File file : files) {
                int len;
                fis = new FileInputStream(file);
                while ((len = fis.read(buf)) >= 0) {
                    if (len <= 0) continue;
                    cp.writeToBulkload(buf, 0, len);
                }
                fis.close();
            }
            ResultSet result = cp.endBulkload();
            this.connection.execSQLUpdate("commit");
            ResultSet resultSet = result;
            return resultSet;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
            if (cp.isActive()) {
                cp.cancelBulkload();
            }
        }
    }

    public StringBuffer escapeDoubleQuotesAndSlash(String str) {
        StringBuffer stringBuffer = new StringBuffer();
        if (str == null || str.isEmpty()) {
            return stringBuffer;
        }
        for (int i = 0; i < str.length(); ++i) {
            char item = str.charAt(i);
            if ('\"' == item || '\\' == item) {
                stringBuffer.append('\\').append(item);
                continue;
            }
            stringBuffer.append(item);
        }
        return stringBuffer;
    }

    private void loadBulkloadCtlFile() throws PSQLException {
        if (this.bulkloadCtlFile != null) {
            try {
                FileInputStream fis = new FileInputStream(new File(this.bulkloadCtlFile));
                this.getBulkloadInfo().load(fis);
            }
            catch (IOException e) {
                throw new PSQLException("error with " + this.bulkloadCtlFile + " file :" + e.getMessage(), PSQLState.INVALID_PARAMETER_VALUE);
            }
        }
    }

    private void checkParams() throws PSQLException {
    }

    private int initFlags() {
        int flags = 0;
        String inputValue = this.getBulkloadInfo().getProperty("INPUT");
        if ("stdin".equals(inputValue.toLowerCase())) {
            flags |= 1;
        }
        return flags;
    }

    public String getBulkloadStartSQL() {
        return this.getBulkloadStartSQL("pgbulkload", "sqlldr");
    }

    public String getBulkloadStartSQL(String schemaName, String functionName) {
        StringBuffer sql = new StringBuffer("SELECT * FROM ").append(schemaName).append(".").append(functionName).append("('{\"");
        int index = 0;
        for (Map.Entry<Object, Object> entry : this.getBulkloadInfo().entrySet()) {
            if (index != 0) {
                sql.append("\",\"");
            }
            sql.append(entry.getKey()).append("=").append(this.escapeDoubleQuotesAndSlash(entry.getValue().toString()));
            ++index;
        }
        sql.append("\"}')");
        return sql.toString();
    }

    public Properties getBulkloadInfo() {
        if (this.bulkloadInfo == null) {
            this.bulkloadInfo = new Properties();
        }
        return this.bulkloadInfo;
    }

    public void setBulkloadInfo(Properties bulkloadInfo) {
        this.bulkloadInfo = bulkloadInfo;
    }
}

