/*
 * Decompiled with CFR 0.152.
 */
package com.highgo.jdbc.bulkload;

import com.highgo.jdbc.bulkload.BulkloadManager;
import com.highgo.jdbc.util.PSQLException;
import com.highgo.jdbc.util.PSQLState;
import java.io.File;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BulkloadFileFolderHandler {
    private final BulkloadManager bulkloadAPI;

    public BulkloadFileFolderHandler(BulkloadManager bulkloadAPI) {
        this.bulkloadAPI = bulkloadAPI;
    }

    public File[] getFilesFromFolder(String folderPath, Pattern fileNamePattern) throws PSQLException {
        if (folderPath == null) {
            throw new PSQLException("the folderPath could not be null.", PSQLState.INVALID_PARAMETER_VALUE);
        }
        File folder = new File(folderPath);
        if (!folder.exists()) {
            throw new PSQLException("the folderPath : \"" + folderPath + "\" is not exists.", PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (!folder.isDirectory()) {
            throw new PSQLException("the folderPath : \"" + folderPath + "\" is not a folder.", PSQLState.INVALID_PARAMETER_VALUE);
        }
        File[] allFiles = folder.listFiles();
        ArrayList<File> result = new ArrayList<File>();
        for (int i = 0; i < allFiles.length; ++i) {
            Matcher matcher = fileNamePattern.matcher(allFiles[i].getName());
            if (!matcher.find()) continue;
            result.add(allFiles[i]);
        }
        return result.toArray(new File[0]);
    }

    public BulkloadManager getBulkloadAPI() {
        return this.bulkloadAPI;
    }
}

