/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.extend.openapi;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class SwaggerEnabledStatusReplaceEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final String REPLACE_SOURCE_NAME = "replaceEnvironment";
    private static final String BALLCAT_OPENAPI_ENABLED_KEY = "ballcat.openapi.enabled";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        String springFoxSwaggerEnabledValue = environment.getProperty("springdoc.api-docs.enabled");
        if (StringUtils.hasText((String)springFoxSwaggerEnabledValue)) {
            return;
        }
        boolean ballcatEnabledOpenApi = true;
        String ballcatOpenApiEnabledValue = environment.getProperty(BALLCAT_OPENAPI_ENABLED_KEY);
        if (StringUtils.hasText((String)ballcatOpenApiEnabledValue)) {
            ballcatEnabledOpenApi = "true".equalsIgnoreCase(ballcatOpenApiEnabledValue);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("springdoc.api-docs.enabled", ballcatEnabledOpenApi);
        this.replace(environment.getPropertySources(), map);
    }

    private void replace(MutablePropertySources propertySources, Map<String, Object> map) {
        PropertySource source;
        MapPropertySource target = null;
        if (propertySources.contains(REPLACE_SOURCE_NAME) && (source = propertySources.get(REPLACE_SOURCE_NAME)) instanceof MapPropertySource) {
            target = (MapPropertySource)source;
            ((Map)target.getSource()).putAll(map);
        }
        if (target == null) {
            target = new MapPropertySource(REPLACE_SOURCE_NAME, map);
        }
        if (!propertySources.contains(REPLACE_SOURCE_NAME)) {
            propertySources.addFirst((PropertySource)target);
        }
    }
}

