/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.extend.openapi;

import com.hccake.ballcat.common.model.domain.PageParam;
import com.hccake.ballcat.common.model.domain.PageParamRequest;
import com.hccake.ballcat.extend.openapi.OpenApiProperties;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import javax.servlet.Filter;
import org.springdoc.core.SpringDocUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@EnableConfigurationProperties(value={OpenApiProperties.class})
@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="ballcat.openapi", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class OpenApiConfiguration {
    private final OpenApiProperties openApiProperties;

    @Bean
    @ConditionalOnMissingBean(value={OpenAPI.class})
    public OpenAPI openAPI() {
        OpenAPI openAPI = new OpenAPI();
        OpenApiProperties.InfoProperties infoProperties = this.openApiProperties.getInfo();
        Info info = this.convertInfo(infoProperties);
        openAPI.info(info);
        openAPI.externalDocs(this.openApiProperties.getExternalDocs());
        openAPI.servers(this.openApiProperties.getServers());
        openAPI.security(this.openApiProperties.getSecurity());
        openAPI.tags(this.openApiProperties.getTags());
        openAPI.paths(this.openApiProperties.getPaths());
        openAPI.components(this.openApiProperties.getComponents());
        openAPI.extensions(this.openApiProperties.getExtensions());
        return openAPI;
    }

    private Info convertInfo(OpenApiProperties.InfoProperties infoProperties) {
        Info info = new Info();
        info.setTitle(infoProperties.getTitle());
        info.setDescription(infoProperties.getDescription());
        info.setTermsOfService(infoProperties.getTermsOfService());
        info.setContact(infoProperties.getContact());
        info.setLicense(infoProperties.getLicense());
        info.setVersion(infoProperties.getVersion());
        info.setExtensions(infoProperties.getExtensions());
        return info;
    }

    @Bean
    @ConditionalOnProperty(prefix="ballcat.openapi.cors-config", name={"enabled"}, havingValue="true")
    public FilterRegistrationBean<CorsFilter> corsFilterRegistrationBean() {
        OpenApiProperties.CorsConfig corsConfig = this.openApiProperties.getCorsConfig();
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        corsConfiguration.setAllowedOrigins(corsConfig.getAllowedOrigins());
        corsConfiguration.setAllowedOriginPatterns(corsConfig.getAllowedOriginPatterns());
        corsConfiguration.setAllowedMethods(corsConfig.getAllowedMethods());
        corsConfiguration.setAllowedHeaders(corsConfig.getAllowedHeaders());
        corsConfiguration.setExposedHeaders(corsConfig.getExposedHeaders());
        corsConfiguration.setAllowCredentials(corsConfig.getAllowCredentials());
        corsConfiguration.setMaxAge(corsConfig.getMaxAge());
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration(corsConfig.getUrlPattern(), corsConfiguration);
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)new CorsFilter((CorsConfigurationSource)source), new ServletRegistrationBean[0]);
        bean.setOrder(Integer.MIN_VALUE);
        return bean;
    }

    public OpenApiConfiguration(OpenApiProperties openApiProperties) {
        this.openApiProperties = openApiProperties;
    }

    static {
        SpringDocUtils config = SpringDocUtils.getConfig();
        config.replaceParameterObjectWithClass(PageParam.class, PageParamRequest.class);
    }
}

