/*
 * Decompiled with CFR 0.152.
 */
package com.grapecity.documents.excel;

import com.grapecity.documents.excel.E.aS;
import com.grapecity.documents.excel.E.bL;
import com.grapecity.documents.excel.E.bT;
import com.grapecity.documents.excel.E.bq;
import com.grapecity.documents.excel.F.S;
import com.grapecity.documents.excel.F.bO;
import com.grapecity.documents.excel.F.bQ;
import com.grapecity.documents.excel.F.o;
import com.grapecity.documents.excel.G.U;
import com.grapecity.documents.excel.IRange;
import com.grapecity.documents.excel.IWorkbook;
import com.grapecity.documents.excel.IWorksheet;
import com.grapecity.documents.excel.Order;
import com.grapecity.documents.excel.PageContentInfo;
import com.grapecity.documents.excel.PageInfo;
import com.grapecity.documents.excel.PageSettings;
import com.grapecity.documents.excel.PaginationOrientation;
import com.grapecity.documents.excel.PdfSaveOptions;
import com.grapecity.documents.excel.Point;
import com.grapecity.documents.excel.Rectangle;
import com.grapecity.documents.excel.RepeatSetting;
import com.grapecity.documents.excel.Size;
import com.grapecity.documents.excel.Visibility;
import com.grapecity.documents.excel.Workbook;
import com.grapecity.documents.excel.bR;
import com.grapecity.documents.excel.cD;
import com.grapecity.documents.excel.cF;
import com.grapecity.documents.excel.cs;
import com.grapecity.documents.excel.dN;
import com.grapecity.documents.excel.dR;
import com.grapecity.documents.excel.h.aB;
import com.grapecity.documents.excel.h.bS;
import com.grapecity.documents.excel.h.cw;
import com.grapecity.documents.excel.h.p;
import com.grapecity.documents.excel.r.a.e;
import com.grapecity.documents.excel.r.i;
import com.grapecity.documents.excel.r.l;
import com.grapecity.documents.excel.w.b;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;

@aS
public class PrintManager {
    private Log a = LogFactory.getLog(PrintManager.class);
    private HashMap<IWorkbook, dN> b = new HashMap();
    private ArrayList<e> c = new ArrayList();

    protected void finalize() throws Throwable {
        if (this.c.size() > 0) {
            for (e e2 : this.c) {
                if (e2 == null) continue;
                e2.b();
            }
        }
        super.finalize();
    }

    @aS
    public final void saveWorkbooksToPDF(OutputStream outputStream, List<IWorkbook> list) {
        List<PageInfo> list2 = this.paginate(list);
        this.savePageInfosToPDF(outputStream, list2);
    }

    @aS
    public final void saveWorkbooksToPDF(OutputStream outputStream, List<IWorkbook> list, PdfSaveOptions pdfSaveOptions) {
        List<PageInfo> list2 = this.paginate(list);
        this.savePageInfosToPDF(outputStream, list2, pdfSaveOptions);
    }

    @aS
    public final void saveWorkbooksToPDF(String string, List<IWorkbook> list) {
        this.saveWorkbooksToPDF(string, list, null);
    }

    @aS
    public final void saveWorkbooksToPDF(String string, List<IWorkbook> list, PdfSaveOptions pdfSaveOptions) {
        if (!cw.g(string)) {
            throw new IllegalArgumentException("Exception_InvalidArgument" + string);
        }
        FileOutputStream fileOutputStream = null;
        try {
            File file = new File(string);
            fileOutputStream = new FileOutputStream(file);
            this.saveWorkbooksToPDF(fileOutputStream, list, pdfSaveOptions);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException(fileNotFoundException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @aS
    public final void savePageInfosToPDF(OutputStream outputStream, List<PageInfo> list) {
        l.a(this, outputStream, list);
    }

    @aS
    public final void savePageInfosToPDF(OutputStream outputStream, List<PageInfo> list, PdfSaveOptions pdfSaveOptions) {
        l.a(this, outputStream, list, pdfSaveOptions);
    }

    @aS
    public final void savePageInfosToPDF(String string, List<PageInfo> list) {
        this.savePageInfosToPDF(string, list, null);
    }

    @aS
    public final void savePageInfosToPDF(String string, List<PageInfo> list, PdfSaveOptions pdfSaveOptions) {
        if (!cw.g(string)) {
            throw new IllegalArgumentException("Exception_InvalidArgument" + string);
        }
        FileOutputStream fileOutputStream = null;
        try {
            File file = new File(string);
            fileOutputStream = new FileOutputStream(file);
            this.savePageInfosToPDF(fileOutputStream, list, pdfSaveOptions);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException(fileNotFoundException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @aS
    public final List<PageInfo> paginate(List<IWorkbook> list) {
        ArrayList<PageInfo> arrayList = new ArrayList<PageInfo>();
        for (IWorkbook iWorkbook : list) {
            arrayList.addAll(this.paginate(iWorkbook));
        }
        this.updatePageNumberAndPageSettings(arrayList);
        return arrayList;
    }

    @aS
    public final List<PageInfo> paginate(IWorkbook iWorkbook) {
        ArrayList<PageInfo> arrayList = new ArrayList<PageInfo>();
        for (IWorksheet iWorksheet : iWorkbook.getWorksheets()) {
            if (iWorksheet.getVisible() != Visibility.Visible) continue;
            arrayList.addAll(this.paginate(iWorksheet));
        }
        this.updatePageNumberAndPageSettings(arrayList);
        return arrayList;
    }

    @aS
    public final List<PageInfo> paginate(IWorksheet iWorksheet) {
        ArrayList<PageInfo> arrayList = new ArrayList<PageInfo>();
        List<IRange> list = this.a(iWorksheet).d();
        for (IRange iRange : list) {
            arrayList.addAll(this.paginate(iRange));
        }
        this.updatePageNumberAndPageSettings(arrayList);
        return arrayList;
    }

    @aS
    public final List<PageInfo> paginate(IWorksheet iWorksheet, List<IRange> list, List<RepeatSetting> list2) {
        ArrayList<PageInfo> arrayList = new ArrayList<PageInfo>();
        List<IRange> list3 = this.a(iWorksheet).d();
        double d2 = this.a(iWorksheet, list, list2);
        for (IRange iRange : list3) {
            arrayList.addAll(this.a(iRange, d2, list, list2));
        }
        this.updatePageNumberAndPageSettings(arrayList);
        return arrayList;
    }

    @aS
    public final PageContentInfo generatePageContentInfo(IRange iRange, Size size, int n2, int n3, boolean bl2, boolean bl3) {
        return this.a(iRange, size, n2, n3, bl2, bl3, -1.0, -1, -1, -1, -1, -1, -1, -1, -1, 1.0);
    }

    @aS
    public final void updatePageNumberAndPageSettings(List<PageInfo> list) {
        l.a(list);
    }

    @aS
    public final void updatePageNumberAndPageSettings(List<PageInfo> list, int n2, int n3) {
        l.a(list, n2, n3);
    }

    @aS
    public final void appendPage(PDDocument pDDocument, PageInfo pageInfo) {
        this.appendPage(pDDocument, pageInfo, null);
    }

    @aS
    public final void appendPage(PDDocument pDDocument, PageInfo pageInfo, PdfSaveOptions pdfSaveOptions) {
        PageSettings pageSettings = pageInfo.b();
        float f2 = (float)pageSettings.getPaperWidth();
        float f3 = (float)pageSettings.getPaperHeight();
        PDRectangle pDRectangle = new PDRectangle(f2, f3);
        PDPage pDPage = new PDPage(pDRectangle);
        pDDocument.addPage(pDPage);
        this.draw(pDDocument, pDPage, new Rectangle(0.0, 0.0, f2, f3), pageInfo, pdfSaveOptions);
    }

    @aS
    public final void draw(PDDocument pDDocument, PDPage pDPage, List<PageInfo> list, int n2, int n3) {
        this.draw(pDDocument, pDPage, list, n2, n3, Order.OverThenDown);
    }

    @aS
    public final void draw(PDDocument pDDocument, PDPage pDPage, List<PageInfo> list, int n2, int n3, Order order) {
        this.draw(pDDocument, pDPage, list, n2, n3, order, null);
    }

    @aS
    public final void draw(PDDocument pDDocument, PDPage pDPage, List<PageInfo> list, int n2, int n3, Order order, PdfSaveOptions pdfSaveOptions) {
        int n4 = 0;
        float f2 = pDPage.getMediaBox().getWidth() / (float)n3;
        float f3 = pDPage.getMediaBox().getHeight() / (float)n2;
        PDPageContentStream pDPageContentStream = null;
        try {
            pDPageContentStream = new PDPageContentStream(pDDocument, pDPage, PDPageContentStream.AppendMode.APPEND, true);
        }
        catch (IOException iOException) {
            this.a.debug((Object)iOException.getMessage());
        }
        for (PageInfo pageInfo : list) {
            int n5 = 0;
            int n6 = 0;
            if (order == Order.OverThenDown) {
                n5 = n4 % n3;
                n6 = n4 / n3;
            } else {
                n5 = n4 / n2;
                n6 = n4 % n2;
            }
            Rectangle rectangle = new Rectangle((float)n5 * f2, (float)n6 * f3, f2, f3);
            bq<e> bq2 = new bq<e>();
            l.a(this.a(pageInfo.getPageContent().getRange().getWorksheet()), pDDocument, pDPage, pDPageContentStream, rectangle, pageInfo, pdfSaveOptions, bq2);
            ++n4;
            this.c.add((e)bq2.a);
        }
        if (pDPageContentStream != null) {
            try {
                pDPageContentStream.close();
            }
            catch (IOException iOException) {
                this.a.debug((Object)iOException.getMessage());
            }
        }
    }

    @aS
    public final boolean hasPrintContent(IRange iRange) {
        return this.a(iRange.getWorksheet()).a(iRange);
    }

    @aS
    public final Size getSize(PageContentInfo pageContentInfo) {
        return pageContentInfo.a(this.a(pageContentInfo.getRange().getWorksheet()));
    }

    @aS
    public final Size getSize(IRange iRange) {
        dR dR2 = this.a(iRange.getWorksheet());
        bS bS2 = dR2.c().d(new p(iRange.getRow(), iRange.getColumn(), iRange.getRowCount(), iRange.getColumnCount()));
        bS2.d *= dR2.a().c();
        return new Size(bS2.c, bS2.d);
    }

    public final dN a(IWorkbook iWorkbook) {
        dN dN2 = this.b.get(iWorkbook);
        if (dN2 != null) {
            return dN2;
        }
        dN2 = new dN((Workbook)iWorkbook);
        this.b.put(iWorkbook, dN2);
        return dN2;
    }

    public final dR a(IWorksheet iWorksheet) {
        dN dN2 = this.a(iWorksheet.getWorkbook());
        return dN2.e().a(iWorksheet.getName());
    }

    @aS
    public final List<PageInfo> paginate(IRange iRange) {
        List<PageInfo> list = l.a(this.a(iRange.getWorksheet()), iRange);
        this.updatePageNumberAndPageSettings(list);
        return list;
    }

    private final List<PageInfo> a(IRange iRange, double d2, List<IRange> list, List<RepeatSetting> list2) {
        PageSettings pageSettings = this.a(iRange.getWorksheet(), bR.a);
        double d3 = pageSettings.getPaperWidth() - pageSettings.getLeftMargin() - pageSettings.getRightMargin();
        double d4 = pageSettings.getPaperHeight() - pageSettings.getTopMargin() - pageSettings.getBottomMargin();
        boolean bl2 = true;
        boolean bl3 = true;
        if (iRange.getWorksheet().getPageSetup().getIsPercentScale() || iRange.getWorksheet().getPageSetup().getFitToPagesTall() <= 0) {
            bl2 = false;
        }
        if (iRange.getWorksheet().getPageSetup().getIsPercentScale() || iRange.getWorksheet().getPageSetup().getFitToPagesWide() <= 0) {
            bl3 = false;
        }
        ArrayList<cF> arrayList = this.a(iRange, d4, list, list2, d2, bl2, false);
        ArrayList<com.grapecity.documents.excel.S> arrayList2 = this.b(iRange, d3, list, list2, d2, bl3, false);
        List<PageInfo> list3 = this.a(arrayList, arrayList2, iRange.getWorksheet().getPageSetup().getOrder());
        this.updatePageNumberAndPageSettings(list3);
        return list3;
    }

    private ArrayList<cF> a(IRange iRange, double d2, List<IRange> list, List<RepeatSetting> list2, double d3, boolean bl2, boolean bl3) {
        ArrayList<cF> arrayList = new ArrayList<cF>();
        int n2 = iRange.getRow();
        int n3 = iRange.getLastRow();
        Object object = null;
        boolean bl4 = false;
        if (iRange.getWorksheet().getPageSetup().getPrintHeadings()) {
            bl4 = true;
        }
        while (true) {
            Object object2;
            int n4 = -1;
            int n5 = -1;
            if (list2 != null && !list2.isEmpty()) {
                object2 = list2.iterator();
                while (object2.hasNext()) {
                    RepeatSetting repeatSetting = object2.next();
                    if (repeatSetting.getRange().getRow() > n2 || repeatSetting.getRange().getLastRow() < n2) continue;
                    if (n2 > repeatSetting.getTitleRowEnd()) {
                        n4 = repeatSetting.getTitleRowStart();
                        n5 = repeatSetting.getTitleRowEnd();
                        break;
                    }
                    if (n2 <= repeatSetting.getTitleRowStart()) break;
                    n2 = repeatSetting.getTitleRowStart();
                    break;
                }
            }
            if ((object2 = this.a(iRange, d3, n4, n5, -1, -1, bl4, n2, d2, bl2)) == null) break;
            int n6 = ((cF)object2).h;
            int n7 = -1;
            int n8 = -1;
            if (list2 != null && !list2.isEmpty()) {
                for (RepeatSetting repeatSetting : list2) {
                    if (repeatSetting.getRange().getRow() > n6 || repeatSetting.getRange().getLastRow() < n6) continue;
                    if (n6 >= repeatSetting.getTailRowEnd()) break;
                    n7 = repeatSetting.getTailRowStart();
                    n8 = repeatSetting.getTailRowEnd();
                    break;
                }
            }
            if (n7 >= 0 && (object2 = this.a(iRange, d3, n4, n5, n7, n8, bl4, n2, d2, bl2)) == null) break;
            if (list != null && !list.isEmpty()) {
                n6 = ((cF)object2).h;
                for (IRange iRange2 : list) {
                    if (((cs)iRange2).a().get(0).f()) continue;
                    bQ bQ2 = this.a(iRange.getWorksheet()).c();
                    double d4 = bQ2.b().b(iRange2.getRow(), iRange2.getLastRow());
                    if (d2 < d4) {
                        throw new IllegalStateException(com.grapecity.documents.excel.w.b.a("Exception_PDF_KeepTogetherHeightTooLarge"));
                    }
                    if (iRange2.getRow() > n6 || iRange2.getLastRow() <= n6) continue;
                    n6 = iRange2.getRow() - 1;
                }
                ((cF)object2).h = n6;
            }
            if (((cF)object2).g > ((cF)object2).h) {
                throw new IllegalStateException(com.grapecity.documents.excel.w.b.a("Exception_PDF_KeepTogetherAndRepeatHeightTooLarge"));
            }
            if (object != null && ((cF)object).g == ((cF)object2).g && ((cF)object).h == ((cF)object2).h) {
                if (bl3) {
                    return null;
                }
                throw new IllegalStateException(com.grapecity.documents.excel.w.b.a("Exception_PDF_TitleAndTailRowsHeightTooLarge"));
            }
            arrayList.add((cF)object2);
            object = object2;
            if (((cF)object2).h >= n3) {
                ((cF)object2).h = n3;
                break;
            }
            n2 = ((cF)object2).h + 1;
        }
        return arrayList;
    }

    private ArrayList<com.grapecity.documents.excel.S> b(IRange iRange, double d2, List<IRange> list, List<RepeatSetting> list2, double d3, boolean bl2, boolean bl3) {
        Object object;
        int n2;
        ArrayList<com.grapecity.documents.excel.S> arrayList = new ArrayList<com.grapecity.documents.excel.S>();
        int n3 = iRange.getColumn();
        int n4 = iRange.getLastColumn();
        Object object2 = null;
        boolean bl4 = false;
        double d4 = -1.0;
        if (iRange.getWorksheet().getPageSetup().getPrintHeadings()) {
            bl4 = true;
            n2 = Math.max(String.valueOf(iRange.getLastRow()).length(), 3);
            IWorkbook iWorkbook = iRange.getWorksheet().getWorkbook();
            object = iRange.getWorksheet().getWorkbook();
            d4 = ((Workbook)iWorkbook).b(aB.b) * (double)n2 + 0.36363636363636365 * ((Workbook)object).p().a((int)0).b.c;
        }
        while (true) {
            n2 = -1;
            int n5 = -1;
            if (list2 != null && !list2.isEmpty()) {
                object = list2.iterator();
                while (object.hasNext()) {
                    RepeatSetting repeatSetting = object.next();
                    if (repeatSetting.getRange().getColumn() > n3 || repeatSetting.getRange().getLastColumn() < n3) continue;
                    if (n3 > repeatSetting.getTitleColumnEnd()) {
                        n2 = repeatSetting.getTitleColumnStart();
                        n5 = repeatSetting.getTitleColumnEnd();
                        break;
                    }
                    if (n3 <= repeatSetting.getTitleColumnStart()) break;
                    n3 = repeatSetting.getTitleColumnStart();
                    break;
                }
            }
            if ((object = this.a(iRange, d3, n2, n5, -1, -1, bl4, d4, n3, d2, bl2)) == null) break;
            int n6 = ((com.grapecity.documents.excel.S)object).h;
            int n7 = -1;
            int n8 = -1;
            if (list2 != null && !list2.isEmpty()) {
                for (RepeatSetting repeatSetting : list2) {
                    if (repeatSetting.getRange().getColumn() > n6 || repeatSetting.getRange().getLastColumn() < n6) continue;
                    if (n6 >= repeatSetting.getTailColumnEnd()) break;
                    n7 = repeatSetting.getTailColumnStart();
                    n8 = repeatSetting.getTailColumnEnd();
                    break;
                }
            }
            if (n7 >= 0 && (object = this.a(iRange, d3, n2, n5, n7, n8, bl4, d4, n3, d2, bl2)) == null) break;
            if (list != null && !list.isEmpty()) {
                n6 = ((com.grapecity.documents.excel.S)object).h;
                for (IRange iRange2 : list) {
                    if (((cs)iRange2).a().get(0).e()) continue;
                    bQ bQ2 = this.a(iRange.getWorksheet()).c();
                    double d5 = bQ2.c().b(iRange2.getColumn(), iRange2.getLastColumn());
                    if (d2 < d5) {
                        throw new IllegalStateException(com.grapecity.documents.excel.w.b.a("Exception_PDF_KeepTogetherWidthTooLarge"));
                    }
                    if (iRange2.getColumn() > n6 || iRange2.getLastColumn() <= n6) continue;
                    n6 = iRange2.getColumn() - 1;
                }
                ((com.grapecity.documents.excel.S)object).h = n6;
            }
            if (((com.grapecity.documents.excel.S)object).g > ((com.grapecity.documents.excel.S)object).h) {
                throw new IllegalStateException(com.grapecity.documents.excel.w.b.a("Exception_PDF_KeepTogetherAndRepeatWidthTooLarge"));
            }
            if (object2 != null && ((com.grapecity.documents.excel.S)object2).g == ((com.grapecity.documents.excel.S)object).g && ((com.grapecity.documents.excel.S)object2).h == ((com.grapecity.documents.excel.S)object).h) {
                if (bl3) {
                    return null;
                }
                throw new IllegalStateException(com.grapecity.documents.excel.w.b.a("Exception_PDF_TitleAndTailColumnsWidthTooLarge"));
            }
            arrayList.add((com.grapecity.documents.excel.S)object);
            object2 = object;
            if (((com.grapecity.documents.excel.S)object).h >= n4) {
                ((com.grapecity.documents.excel.S)object).h = n4;
                break;
            }
            n3 = ((com.grapecity.documents.excel.S)object).h + 1;
        }
        return arrayList;
    }

    private final List<cF> a(IRange iRange) {
        return l.a(this.a(iRange.getWorksheet()), ((cs)iRange).b().get(0));
    }

    private final List<cF> a(IRange iRange, double d2, int n2, boolean bl2) {
        dR dR2 = this.a(iRange.getWorksheet());
        boolean bl3 = dR2.b().getPageSetup().getPrintHeadings();
        cD cD2 = dR2.j();
        PageSettings pageSettings = dR2.a(bR.a);
        double d3 = pageSettings.a().d;
        ArrayList<cF> arrayList = this.a(iRange, d2, bl2, d3, bl3, cD2);
        if (n2 <= 0 || arrayList.size() < n2) {
            return arrayList;
        }
        double d4 = 0.0;
        double d5 = d2;
        while (d5 - d4 > 0.1) {
            d2 = (d4 + d5) / 2.0;
            arrayList = this.a(iRange, d2, bl2, d3, bl3, cD2);
            if (arrayList.size() < n2) {
                d4 = d2;
                continue;
            }
            d5 = d2;
        }
        return arrayList;
    }

    private ArrayList<cF> a(IRange iRange, double d2, boolean bl2, double d3, boolean bl3, cD cD2) {
        cF cF2;
        ArrayList<cF> arrayList = new ArrayList<cF>();
        int n2 = iRange.getRow();
        while ((cF2 = this.a(iRange, d2, cD2.a, cD2.b, cD2.c, cD2.d, bl3, n2, d3, bl2, true)) != null) {
            if (cF2.h >= iRange.getLastRow()) {
                cF2.h = iRange.getLastRow();
                arrayList.add(cF2);
                break;
            }
            arrayList.add(cF2);
            n2 = cF2.h + 1;
        }
        return arrayList;
    }

    private final List<com.grapecity.documents.excel.S> b(IRange iRange) {
        return l.b(this.a(iRange.getWorksheet()), ((cs)iRange).b().get(0));
    }

    private final List<com.grapecity.documents.excel.S> a(IRange iRange, double d2, int n2, double d3, boolean bl2) {
        dR dR2 = this.a(iRange.getWorksheet());
        dR2.b().getPageSetup().getPrintHeadings();
        cD cD2 = dR2.j();
        PageSettings pageSettings = dR2.a(bR.a);
        double d4 = pageSettings.a().c;
        ArrayList<com.grapecity.documents.excel.S> arrayList = this.a(iRange, d2, bl2, d4, d3, cD2);
        if (n2 <= 0 || arrayList.size() < n2) {
            return arrayList;
        }
        double d5 = 0.0;
        double d6 = d2;
        while (d6 - d5 > 0.1) {
            d2 = (d5 + d6) / 2.0;
            arrayList = this.a(iRange, d2, bl2, d4, d3, cD2);
            if (arrayList.size() < n2) {
                d5 = d2;
                continue;
            }
            d6 = d2;
        }
        return arrayList;
    }

    private ArrayList<com.grapecity.documents.excel.S> a(IRange iRange, double d2, boolean bl2, double d3, double d4, cD cD2) {
        com.grapecity.documents.excel.S s2;
        ArrayList<com.grapecity.documents.excel.S> arrayList = new ArrayList<com.grapecity.documents.excel.S>();
        int n2 = iRange.getColumn();
        while ((s2 = this.a(iRange, d2, cD2.a, cD2.b, cD2.c, cD2.d, d4 > 0.0, d4, n2, d3, bl2, true)) != null) {
            if (s2.h >= iRange.getLastColumn()) {
                s2.h = iRange.getLastColumn();
                arrayList.add(s2);
                break;
            }
            arrayList.add(s2);
            n2 = s2.h + 1;
        }
        return arrayList;
    }

    private final List<PageInfo> a(List<cF> list, List<com.grapecity.documents.excel.S> list2, Order order) {
        PageInfo pageInfo;
        int n2;
        int n3;
        ArrayList<PageInfo> arrayList = new ArrayList<PageInfo>();
        p.n();
        p.n();
        if (order == Order.DownThenOver) {
            for (n3 = 0; n3 < list2.size(); ++n3) {
                for (n2 = 0; n2 < list.size(); ++n2) {
                    if (!list2.get((int)n3).b.equals(list.get((int)n2).b)) {
                        throw new IllegalStateException();
                    }
                    pageInfo = new PageInfo();
                    pageInfo.setPageContent(new PageContentInfo(list.get(n2), list2.get(n3)));
                    arrayList.add(pageInfo);
                }
            }
        } else {
            for (n3 = 0; n3 < list.size(); ++n3) {
                for (n2 = 0; n2 < list2.size(); ++n2) {
                    if (!list2.get((int)n2).b.equals(list.get((int)n3).b)) {
                        throw new IllegalStateException();
                    }
                    pageInfo = new PageInfo();
                    pageInfo.setPageContent(new PageContentInfo(list.get(n3), list2.get(n2)));
                    arrayList.add(pageInfo);
                }
            }
        }
        if (arrayList.size() <= 0) {
            return arrayList;
        }
        if (bL.a(list.get((int)0).b.getPageSetup().getPrintArea()) && bL.a(list.get((int)0).b.getPageSetup().getPrintTitleRows()) && bL.a(list.get((int)0).b.getPageSetup().getPrintTitleColumns())) {
            PageInfo pageInfo2;
            while (!arrayList.isEmpty() && !this.a((pageInfo2 = arrayList.get(arrayList.size() - 1)).getPageContent().getRange().getWorksheet()).a(pageInfo2.getPageContent().getRange())) {
                arrayList.remove(arrayList.size() - 1);
            }
        }
        this.updatePageNumberAndPageSettings(arrayList);
        return arrayList;
    }

    @aS
    public final void draw(PDDocument pDDocument, PDPage pDPage, Point point, IRange iRange) {
        Size size = this.getSize(iRange);
        this.draw(pDDocument, pDPage, new Rectangle(point.getX(), point.getY(), (float)size.getWidth(), (float)size.getHeight()), iRange);
    }

    @aS
    public final void draw(PDDocument pDDocument, PDPage pDPage, Point point, IRange iRange, PdfSaveOptions pdfSaveOptions) {
        Size size = this.getSize(iRange);
        this.draw(pDDocument, pDPage, new Rectangle(point.getX(), point.getY(), (float)size.getWidth(), (float)size.getHeight()), iRange, pdfSaveOptions);
    }

    @aS
    private final void draw(PDDocument pDDocument, PDPage pDPage, Point point, PageContentInfo pageContentInfo) {
        this.draw(pDDocument, pDPage, new Rectangle(point.getX(), point.getY(), this.getSize(pageContentInfo).getWidth(), this.getSize(pageContentInfo).getHeight()), pageContentInfo);
    }

    @aS
    private final void draw(PDDocument pDDocument, PDPage pDPage, Point point, PageInfo pageInfo) {
        PageSettings pageSettings = pageInfo.b();
        this.draw(pDDocument, pDPage, new Rectangle(point.getX(), point.getY(), (float)pageSettings.getPaperWidth(), (float)pageSettings.getPaperHeight()), pageInfo);
    }

    @aS
    public final void draw(PDDocument pDDocument, PDPage pDPage, Rectangle rectangle, IRange iRange) {
        this.draw(pDDocument, pDPage, rectangle, iRange, null);
    }

    @aS
    public final void draw(PDDocument pDDocument, PDPage pDPage, Rectangle rectangle, IRange iRange, PdfSaveOptions pdfSaveOptions) {
        PageSettings pageSettings = this.a(iRange.getWorksheet(), bR.a);
        o o2 = new o();
        dR dR2 = this.a(iRange.getWorksheet());
        boolean bl2 = pdfSaveOptions != null && pdfSaveOptions.getPrintTransparentCell();
        o2.a(dR2, iRange.getRow(), iRange.getColumn(), iRange.getRow() + iRange.getRows().getCount() - 1, iRange.getColumn() + iRange.getColumns().getCount() - 1, pageSettings, bl2);
        l.a(pDDocument, dR2.a().d());
        if (pdfSaveOptions != null) {
            if (pdfSaveOptions.getDocumentProperties() != null) {
                l.a(pDDocument, pdfSaveOptions.getDocumentProperties());
            }
            if (pdfSaveOptions.getSecurityOptions() != null) {
                l.a(pDDocument, pdfSaveOptions.getSecurityOptions());
            }
        }
        i i2 = null;
        PDPageContentStream pDPageContentStream = null;
        e e2 = new e();
        e2.a();
        try {
            pDPageContentStream = new PDPageContentStream(pDDocument, pDPage, PDPageContentStream.AppendMode.APPEND, true);
            i2 = new i(pDDocument, pDPage, pDPageContentStream, e2, pdfSaveOptions, null);
        }
        catch (IOException iOException) {
            this.a.debug((Object)iOException.getMessage());
        }
        S s2 = o2.E();
        if (s2 != null) {
            bQ bQ2 = this.a(iRange.getWorksheet()).c();
            double d2 = bQ2.b().b(iRange.getRow(), iRange.getRow() + iRange.getRows().getCount() - 1) * dR2.a().c();
            double d3 = bQ2.c().b(iRange.getColumn(), iRange.getColumn() + iRange.getColumns().getCount() - 1);
            double d4 = 1.0;
            if (d3 > rectangle.getWidth()) {
                d4 = rectangle.getWidth() / d3;
            }
            double d5 = 1.0;
            if (d2 > rectangle.getHeight()) {
                d5 = rectangle.getHeight() / d2;
            }
            double d6 = d4 < d5 ? d4 : d5;
            s2.d(d6, d6 * dR2.a().c());
            s2.c(rectangle.getX() + (rectangle.getWidth() - (d3 *= d6)) / 2.0, rectangle.getY() + (rectangle.getHeight() - (d2 *= d6)) / 2.0);
            s2.h();
            i2.a(s2);
            try {
                if (pDPageContentStream != null) {
                    pDPageContentStream.close();
                }
            }
            catch (IOException iOException) {
                this.a.debug((Object)iOException.getMessage());
            }
        }
        this.c.add(e2);
    }

    @aS
    public final void draw(PDDocument pDDocument, PDPage pDPage, Rectangle rectangle, PageContentInfo pageContentInfo) {
        this.draw(pDDocument, pDPage, rectangle, pageContentInfo, null);
    }

    @aS
    public final void draw(PDDocument pDDocument, PDPage pDPage, Rectangle rectangle, PageContentInfo pageContentInfo, PdfSaveOptions pdfSaveOptions) {
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageContent(pageContentInfo);
        pageInfo.setPageSettings(this.a(pageContentInfo.getRange().getWorksheet()).a(bR.a));
        Size size = this.getSize(pageContentInfo);
        pageInfo.getPageSettings().setPaperWidth(size.getWidth());
        pageInfo.getPageSettings().setPaperHeight(size.getHeight());
        pageInfo.getPageSettings().setTopMargin(0.0);
        pageInfo.getPageSettings().setBottomMargin(0.0);
        pageInfo.getPageSettings().setLeftMargin(0.0);
        pageInfo.getPageSettings().setRightMargin(0.0);
        this.draw(pDDocument, pDPage, rectangle, pageInfo, pdfSaveOptions);
    }

    @aS
    public final void draw(PDDocument pDDocument, PDPage pDPage, Rectangle rectangle, PageInfo pageInfo) {
        this.draw(pDDocument, pDPage, rectangle, pageInfo, null);
    }

    @aS
    public final void draw(PDDocument pDDocument, PDPage pDPage, Rectangle rectangle, PageInfo pageInfo, PdfSaveOptions pdfSaveOptions) {
        PDPageContentStream pDPageContentStream = null;
        try {
            pDPageContentStream = new PDPageContentStream(pDDocument, pDPage, PDPageContentStream.AppendMode.APPEND, true);
        }
        catch (IOException iOException) {
            this.a.debug((Object)iOException.getMessage());
        }
        bq<e> bq2 = new bq<e>();
        l.a(this.a(pageInfo.getPageContent().getRange().getWorksheet()), pDDocument, pDPage, pDPageContentStream, rectangle, pageInfo, pdfSaveOptions, bq2);
        this.c.add((e)bq2.a);
        if (pDPageContentStream != null) {
            try {
                pDPageContentStream.close();
            }
            catch (IOException iOException) {
                this.a.debug((Object)iOException.getMessage());
            }
        }
    }

    private final cF a(IRange iRange, double d2, int n2, int n3, int n4, int n5, boolean bl2, int n6, double d3, boolean bl3) {
        return this.a(iRange, d2, n2, n3, n4, n5, bl2, n6, d3, bl3, false);
    }

    private final cF a(IRange iRange, double d2, int n2, int n3, int n4, int n5, boolean bl2, int n6, double d3, boolean bl3, boolean bl4) {
        boolean bl5;
        boolean bl6 = n2 >= 0 && n3 >= n2;
        boolean bl7 = bl5 = n4 >= 0 && n5 >= n4;
        if (bl4 && bl6 && n6 < n3) {
            n6 = Math.min(n6, n2);
            n2 = -1;
            n3 = -1;
            bl6 = false;
        }
        cF cF2 = new cF();
        cF2.a = this.a(iRange.getWorksheet());
        cF2.b = iRange.getWorksheet();
        cF2.a(d2);
        cF2.c = n2;
        cF2.d = n3;
        cF2.i = bl2;
        d3 /= this.a(iRange.getWorksheet()).a().c();
        if (d2 > 0.0 && d2 != 1.0) {
            d3 /= d2;
        }
        bQ bQ2 = this.a(iRange.getWorksheet()).c();
        bO bO2 = bQ2.b();
        if (bl2) {
            d3 -= bQ2.i();
        }
        if (bl6) {
            d3 -= bO2.b(n2, n3);
        }
        if (bl5) {
            d3 -= bO2.b(n4, n5);
        }
        if (d3 <= 0.0) {
            return null;
        }
        bT<Integer, Integer> bT2 = bO2.b(n6, d3);
        if ((Integer)bT2.a < 0 || (Integer)bT2.b < 0 || (Integer)bT2.a > iRange.getLastRow()) {
            return null;
        }
        cF2.g = (Integer)bT2.a;
        cF2.h = (Integer)bT2.b;
        if (bl4 && bl5 && cF2.h >= n4) {
            bT2 = bO2.b(n6, d3 += bO2.b(n4, n5));
            cF2.g = (Integer)bT2.a;
            cF2.h = (Integer)bT2.b;
            cF2.e = -1;
            cF2.f = -1;
        } else {
            cF2.e = n4;
            cF2.f = n5;
        }
        cF2.j = -1;
        cF2.k = 0;
        if (!bl3) {
            List<U> list = this.a(iRange.getWorksheet()).h();
            if (list == null || list.size() == 0) {
                return cF2;
            }
            for (U u2 : list) {
                if (u2.a > cF2.h) break;
                if (u2.a <= cF2.g || u2.b > iRange.getColumn() + iRange.getColumns().getCount() - 1 || u2.c <= iRange.getColumn()) continue;
                cF2.h = u2.a - 1;
            }
        }
        if (bl5 && cF2.h < n4) {
            cF2.e = n4;
            cF2.f = n5;
        }
        return cF2;
    }

    private final com.grapecity.documents.excel.S a(IRange iRange, double d2, int n2, int n3, int n4, int n5, boolean bl2, double d3, int n6, double d4, boolean bl3) {
        return this.a(iRange, d2, n2, n3, n4, n5, bl2, d3, n6, d4, bl3, false);
    }

    private final com.grapecity.documents.excel.S a(IRange iRange, double d2, int n2, int n3, int n4, int n5, boolean bl2, double d3, int n6, double d4, boolean bl3, boolean bl4) {
        boolean bl5;
        boolean bl6 = n2 >= 0 && n3 >= n2;
        boolean bl7 = bl5 = n4 >= 0 && n5 >= n4;
        if (bl4 && bl6 && n6 < n3) {
            n6 = Math.min(n6, n2);
            n2 = -1;
            n3 = -1;
            bl6 = false;
        }
        com.grapecity.documents.excel.S s2 = new com.grapecity.documents.excel.S();
        s2.a = this.a(iRange.getWorksheet());
        s2.b = iRange.getWorksheet();
        s2.a(d2);
        s2.c = n2;
        s2.d = n3;
        s2.j = bl2;
        s2.i = d3;
        s2.b = iRange.getWorksheet();
        if (d2 > 0.0 && d2 != 1.0) {
            d4 /= d2;
        }
        bQ bQ2 = this.a(iRange.getWorksheet()).c();
        bO bO2 = bQ2.c();
        if (bl2) {
            d4 -= d3;
        }
        if (bl6) {
            d4 -= bO2.b(n2, n3);
        }
        if (bl5) {
            d4 -= bO2.b(n4, n5);
        }
        if (d4 <= 0.0) {
            return null;
        }
        bT<Integer, Integer> bT2 = bO2.b(n6, d4);
        if ((Integer)bT2.a < 0 || (Integer)bT2.b < 0 || (Integer)bT2.a > iRange.getLastColumn()) {
            return null;
        }
        s2.g = (Integer)bT2.a;
        s2.h = (Integer)bT2.b;
        if (bl5 && s2.h >= n4) {
            bT2 = bO2.b(n6, d4 += bO2.b(n4, n5));
            s2.g = (Integer)bT2.a;
            s2.h = (Integer)bT2.b;
            s2.e = -1;
            s2.f = -1;
        } else {
            s2.e = n4;
            s2.f = n5;
        }
        s2.l = 0;
        s2.k = -1;
        if (!bl3) {
            List<U> list = this.a(iRange.getWorksheet()).i();
            if (list == null || list.size() == 0) {
                return s2;
            }
            for (U u2 : list) {
                if (u2.a > s2.h) break;
                if (u2.a <= s2.g || u2.b > iRange.getRow() + iRange.getRows().getCount() - 1 || u2.c <= iRange.getRow()) continue;
                s2.h = u2.a - 1;
            }
        }
        if (bl5 && s2.h < n4) {
            s2.e = n4;
            s2.f = n5;
        }
        return s2;
    }

    public final PageContentInfo a(IRange iRange, Size size, int n2, int n3, boolean bl2, boolean bl3, double d2, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, double d3, boolean bl4) {
        return this.a(iRange, size, n2, n3, bl2, bl3, d2, n4, n5, n6, n7, n8, n9, n10, n11, d3, bl4, false);
    }

    private final PageContentInfo a(IRange iRange, Size size, int n2, int n3, boolean bl2, boolean bl3, double d2, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, double d3) {
        return this.a(iRange, size, n2, n3, bl2, bl3, d2, n4, n5, n6, n7, n8, n9, n10, n11, d3, false, false);
    }

    private final PageContentInfo a(IRange iRange, Size size, int n2, int n3, boolean bl2, boolean bl3, double d2, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, double d3, boolean bl4, boolean bl5) {
        PageContentInfo pageContentInfo = new PageContentInfo();
        pageContentInfo.setZoomFactor(d3);
        pageContentInfo.setTitleRowStart(n4);
        pageContentInfo.setTitleRowEnd(n5);
        pageContentInfo.setTailRowStart(n6);
        pageContentInfo.setTailRowEnd(n7);
        pageContentInfo.setColumnHeaderVisible(bl3);
        pageContentInfo.setTitleColumnStart(n8);
        pageContentInfo.setTitleColumnEnd(n9);
        pageContentInfo.setTailColumnStart(n10);
        pageContentInfo.setTailColumnEnd(n11);
        pageContentInfo.setRowHeaderVisible(bl2);
        pageContentInfo.a(d2);
        pageContentInfo.b(0);
        pageContentInfo.a(-1);
        pageContentInfo.d(0);
        pageContentInfo.c(-1);
        pageContentInfo.a(this.a(iRange.getWorksheet()), iRange, n2, n3, size, bl4, bl5, false);
        return pageContentInfo;
    }

    @aS
    public final List<IRange> getPrintAreas(IWorksheet iWorksheet) {
        return this.a(iWorksheet).d();
    }

    public final PageSettings a(IWorksheet iWorksheet, bR bR2) {
        return this.a(iWorksheet).a(bR2);
    }

    @aS
    public List<Integer> GetPaginationInfo(IWorksheet iWorksheet, PaginationOrientation paginationOrientation) {
        if (paginationOrientation == PaginationOrientation.Horizontal) {
            return l.b(this.a(iWorksheet));
        }
        return l.c(this.a(iWorksheet));
    }

    @aS
    public List<Integer> GetPaginationInfo(IWorksheet iWorksheet, PaginationOrientation paginationOrientation, List<IRange> list, List<RepeatSetting> list2) {
        List<IRange> list3 = this.a(iWorksheet).d();
        if (list3.size() <= 0) {
            return null;
        }
        boolean bl2 = true;
        boolean bl3 = true;
        if (iWorksheet.getPageSetup().getIsPercentScale() || iWorksheet.getPageSetup().getFitToPagesTall() <= 0) {
            bl2 = false;
        }
        if (iWorksheet.getPageSetup().getIsPercentScale() || iWorksheet.getPageSetup().getFitToPagesWide() <= 0) {
            bl3 = false;
        }
        double d2 = this.a(iWorksheet, list, list2);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (IRange iRange : list3) {
            ArrayList<Object> arrayList2;
            PageSettings pageSettings = this.a(iWorksheet, bR.a);
            double d3 = pageSettings.getPaperWidth() - pageSettings.getLeftMargin() - pageSettings.getRightMargin();
            double d4 = pageSettings.getPaperHeight() - pageSettings.getTopMargin() - pageSettings.getBottomMargin();
            if (paginationOrientation == PaginationOrientation.Horizontal) {
                arrayList2 = this.b(iRange, d3, list, list2, d2, bl3, false);
                for (Object object : arrayList2) {
                    arrayList.add(((com.grapecity.documents.excel.S)object).h);
                }
                continue;
            }
            arrayList2 = this.a(iRange, d4, list, list2, d2, bl2, false);
            for (Object object : arrayList2) {
                arrayList.add(((cF)object).h);
            }
        }
        return arrayList;
    }

    private double a(IWorksheet iWorksheet, List<IRange> list, List<RepeatSetting> list2) {
        List<IRange> list3 = this.a(iWorksheet).d();
        if (list3.size() <= 0) {
            return 1.0;
        }
        if (iWorksheet.getPageSetup().getIsPercentScale()) {
            return (double)iWorksheet.getPageSetup().getZoom() / 100.0;
        }
        double d2 = 1.0;
        for (IRange iRange : list3) {
            PageSettings pageSettings = this.a(iWorksheet, bR.a);
            double d3 = pageSettings.getPaperWidth() - pageSettings.getLeftMargin() - pageSettings.getRightMargin();
            double d4 = pageSettings.getPaperHeight() - pageSettings.getTopMargin() - pageSettings.getBottomMargin();
            Size size = new Size(d3, d4);
            d2 = this.a(this.a(iRange.getWorksheet()), iRange, size, d2, list, list2);
        }
        d2 = (double)((int)(d2 * 100.0)) / 100.0;
        return d2;
    }

    private double a(dR dR2, IRange iRange, Size size, double d2, List<IRange> list, List<RepeatSetting> list2) {
        if (dR2.b().getPageSetup().getFitToPagesTall() > 0) {
            d2 = this.a(dR2, iRange, size.getHeight(), dR2.b().getPageSetup().getFitToPagesTall(), d2, list, list2);
        }
        if (dR2.b().getPageSetup().getFitToPagesWide() > 0) {
            d2 = this.b(dR2, iRange, size.getWidth(), dR2.b().getPageSetup().getFitToPagesWide(), d2, list, list2);
        }
        return d2;
    }

    private double a(dR dR2, IRange iRange, double d2, int n2, double d3, List<IRange> list, List<RepeatSetting> list2) {
        ArrayList<cF> arrayList = this.a(iRange, d2, list, list2, d3, true, true);
        if (arrayList != null && arrayList.size() <= n2) {
            return d3;
        }
        double d4 = d3;
        double d5 = 0.0;
        double d6 = arrayList == null ? d3 / 2.0 : (double)n2 * d3 / (double)arrayList.size();
        int n3 = 0;
        while (n3++ < 20) {
            arrayList = this.a(iRange, d2, list, list2, d6, true, true);
            if (arrayList == null || arrayList.size() > n2) {
                d4 = d6;
            } else {
                d5 = d6;
            }
            if (Math.abs(d4 - d5) < 0.01) break;
            d6 = (d4 + d5) / 2.0;
        }
        if (arrayList.size() > n2) {
            d6 = d5;
        }
        return d6;
    }

    private double b(dR dR2, IRange iRange, double d2, int n2, double d3, List<IRange> list, List<RepeatSetting> list2) {
        ArrayList<com.grapecity.documents.excel.S> arrayList = this.b(iRange, d2, list, list2, d3, true, true);
        if (arrayList != null && arrayList.size() <= n2) {
            return d3;
        }
        double d4 = d3;
        double d5 = 0.0;
        double d6 = arrayList == null ? d3 / 2.0 : (double)n2 * d3 / (double)arrayList.size();
        int n3 = 0;
        while (n3++ < 20) {
            arrayList = this.b(iRange, d2, list, list2, d6, true, true);
            if (arrayList == null || arrayList.size() > n2) {
                d4 = d6;
            } else {
                d5 = d6;
            }
            if (Math.abs(d4 - d5) < 0.01) break;
            d6 = (d4 + d5) / 2.0;
        }
        if (arrayList.size() > n2) {
            d6 = d5;
        }
        return d6;
    }
}

