/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.origin;

import java.time.Duration;

public class OriginMetadata {
    private final String buildInvocationId;
    private final Duration executionTime;

    public OriginMetadata(String string, Duration duration) {
        this.buildInvocationId = string;
        this.executionTime = duration;
    }

    public String getBuildInvocationId() {
        return this.buildInvocationId;
    }

    public Duration getExecutionTime() {
        return this.executionTime;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        OriginMetadata originMetadata = (OriginMetadata)object;
        if (!this.buildInvocationId.equals(originMetadata.buildInvocationId)) {
            return false;
        }
        return this.executionTime.equals(originMetadata.executionTime);
    }

    public int hashCode() {
        int n2 = this.buildInvocationId.hashCode();
        n2 = 31 * n2 + this.executionTime.hashCode();
        return n2;
    }

    public String toString() {
        return "OriginMetadata{buildInvocationId=" + this.buildInvocationId + ", executionTime=" + this.executionTime + '}';
    }
}

