/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.caching.internal.controller.BuildCacheLoadCommand;
import org.gradle.caching.internal.controller.BuildCacheStoreCommand;
import org.gradle.caching.internal.controller.service.BuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.BuildCacheServiceHandleFactory;
import org.gradle.caching.internal.controller.service.BuildCacheServiceRole;
import org.gradle.caching.internal.controller.service.BuildCacheServicesConfiguration;
import org.gradle.caching.internal.controller.service.LoadTarget;
import org.gradle.caching.internal.controller.service.LocalBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.NullLocalBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.StoreTarget;
import org.gradle.caching.local.internal.BuildCacheTempFileStore;
import org.gradle.caching.local.internal.DefaultBuildCacheTempFileStore;

public class DefaultBuildCacheController
implements BuildCacheController {
    private final BuildCacheServiceHandle remote;
    private final LocalBuildCacheServiceHandle local;
    private final boolean emitDebugLogging;
    private final BuildCacheTempFileStore tmp;
    private boolean closed;

    public DefaultBuildCacheController(BuildCacheServicesConfiguration buildCacheServicesConfiguration, BuildCacheServiceHandleFactory buildCacheServiceHandleFactory, Supplier<Path> supplier, boolean bl2, boolean bl3) {
        this.emitDebugLogging = bl3;
        if (buildCacheServicesConfiguration.local == null) {
            this.local = NullLocalBuildCacheServiceHandle.INSTANCE;
            this.tmp = new DefaultBuildCacheTempFileStore(() -> ((Path)supplier.get()).resolve("build-cache-tmp"));
        } else {
            this.local = buildCacheServiceHandleFactory.toHandle(buildCacheServicesConfiguration.local, buildCacheServicesConfiguration.localPush);
            this.tmp = buildCacheServicesConfiguration.local;
        }
        this.remote = buildCacheServiceHandleFactory.toHandle(buildCacheServicesConfiguration.remote, buildCacheServicesConfiguration.remotePush, BuildCacheServiceRole.REMOTE, bl2);
    }

    @Override
    public <T> Optional<T> load(BuildCacheLoadCommand<T> buildCacheLoadCommand) {
        BuildCacheLoadCommand.Result result;
        Unpack unpack = new Unpack(buildCacheLoadCommand);
        if (this.local.canLoad()) {
            try {
                this.local.load(buildCacheLoadCommand.getKey(), unpack);
            }
            catch (Exception exception) {
                throw new BuildCacheException("Build cache entry " + buildCacheLoadCommand.getKey().getHashCode() + " from local build cache is invalid", exception);
            }
            if (unpack.result != null) {
                return Optional.of(unpack.result.getMetadata());
            }
        }
        if (this.remote.canLoad()) {
            this.tmp.withTempFile(buildCacheLoadCommand.getKey(), file -> {
                LoadTarget loadTarget = new LoadTarget((File)file);
                if (this.remote.canLoad() && !loadTarget.isLoaded()) {
                    this.remote.load(buildCacheLoadCommand.getKey(), loadTarget);
                }
                if (loadTarget.isLoaded()) {
                    try {
                        unpack.accept((File)file);
                    }
                    catch (Exception exception) {
                        String string = BuildCacheServiceRole.REMOTE.getDisplayName();
                        throw new BuildCacheException("Build cache entry " + buildCacheLoadCommand.getKey().getHashCode() + " from " + string + " build cache is invalid", exception);
                    }
                    if (this.local.canStore()) {
                        this.local.store(buildCacheLoadCommand.getKey(), (File)file);
                    }
                }
            });
        }
        return (result = unpack.result) == null ? Optional.empty() : Optional.of(result.getMetadata());
    }

    @Override
    public void store(BuildCacheStoreCommand buildCacheStoreCommand) {
        boolean bl2;
        boolean bl3 = bl2 = this.local.canStore() || this.remote.canStore();
        if (!bl2) {
            return;
        }
        BuildCacheKey buildCacheKey = buildCacheStoreCommand.getKey();
        Pack pack = new Pack(buildCacheStoreCommand);
        this.tmp.withTempFile(buildCacheStoreCommand.getKey(), file -> {
            pack.accept((File)file);
            if (this.remote.canStore()) {
                this.remote.store(buildCacheKey, new StoreTarget((File)file));
            }
            if (this.local.canStore()) {
                this.local.store(buildCacheKey, (File)file);
            }
        });
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            try {
                this.local.close();
            }
            finally {
                this.remote.close();
            }
        }
    }

    private class Unpack<T>
    implements Consumer<File> {
        private final BuildCacheLoadCommand<T> command;
        private BuildCacheLoadCommand.Result<T> result;

        private Unpack(BuildCacheLoadCommand<T> buildCacheLoadCommand) {
            this.command = buildCacheLoadCommand;
        }

        @Override
        public void accept(File file) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                this.result = this.command.load(fileInputStream);
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        }
    }

    private class Pack
    implements Consumer<File> {
        private final BuildCacheStoreCommand command;

        private Pack(BuildCacheStoreCommand buildCacheStoreCommand) {
            this.command = buildCacheStoreCommand;
        }

        @Override
        public void accept(File file) {
            try {
                this.command.store(new FileOutputStream(file));
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        }
    }
}

