/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.util;

import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ObjectUtils;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class ConcurrentReferenceHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    private static final ReferenceType DEFAULT_REFERENCE_TYPE = ReferenceType.SOFT;
    private final Segment[] segments;
    private final float loadFactor;
    private final ReferenceType referenceType;
    private final int shift;
    private volatile Set<Map.Entry<K, V>> entrySet;

    public ConcurrentReferenceHashMap() {
        this(16, 0.75f, 16, DEFAULT_REFERENCE_TYPE);
    }

    public ConcurrentReferenceHashMap(int n2) {
        this(n2, 0.75f, 16, DEFAULT_REFERENCE_TYPE);
    }

    public ConcurrentReferenceHashMap(int n2, float f2, int n3, ReferenceType referenceType) {
        Assert.isTrue(n2 >= 0, "Initial capacity must not be negative");
        Assert.isTrue(f2 > 0.0f, "Load factor must be positive");
        Assert.isTrue(n3 > 0, "Concurrency level must be positive");
        Assert.notNull((Object)referenceType, "Reference type must not be null");
        this.loadFactor = f2;
        this.shift = ConcurrentReferenceHashMap.calculateShift(n3, 65536);
        int n4 = 1 << this.shift;
        this.referenceType = referenceType;
        int n5 = (int)(((long)(n2 + n4) - 1L) / (long)n4);
        int n6 = 1 << ConcurrentReferenceHashMap.calculateShift(n5, 0x40000000);
        Segment[] segmentArray = (Segment[])Array.newInstance(Segment.class, n4);
        int n7 = (int)((float)n6 * this.getLoadFactor());
        for (int i2 = 0; i2 < segmentArray.length; ++i2) {
            segmentArray[i2] = new Segment(n6, n7);
        }
        this.segments = segmentArray;
    }

    protected final float getLoadFactor() {
        return this.loadFactor;
    }

    protected ReferenceManager createReferenceManager() {
        return new ReferenceManager();
    }

    protected int getHash(Object object) {
        int n2 = object != null ? object.hashCode() : 0;
        n2 += n2 << 15 ^ 0xFFFFCD7D;
        n2 ^= n2 >>> 10;
        n2 += n2 << 3;
        n2 ^= n2 >>> 6;
        n2 += (n2 << 2) + (n2 << 14);
        n2 ^= n2 >>> 16;
        return n2;
    }

    @Override
    public V get(Object object) {
        Reference<K, V> reference = this.getReference(object, Restructure.WHEN_NECESSARY);
        Entry<K, V> entry = reference != null ? reference.get() : null;
        return entry != null ? (V)entry.getValue() : null;
    }

    @Override
    public V getOrDefault(Object object, V v2) {
        Reference<K, V> reference = this.getReference(object, Restructure.WHEN_NECESSARY);
        Entry<K, V> entry = reference != null ? reference.get() : null;
        return entry != null ? entry.getValue() : v2;
    }

    @Override
    public boolean containsKey(Object object) {
        Reference<K, V> reference = this.getReference(object, Restructure.WHEN_NECESSARY);
        Entry<K, V> entry = reference != null ? reference.get() : null;
        return entry != null && ObjectUtils.nullSafeEquals(entry.getKey(), object);
    }

    protected final Reference<K, V> getReference(Object object, Restructure restructure) {
        int n2 = this.getHash(object);
        return this.getSegmentForHash(n2).getReference(object, n2, restructure);
    }

    @Override
    public V put(K k2, V v2) {
        return this.put(k2, v2, true);
    }

    @Override
    public V putIfAbsent(K k2, V v2) {
        return this.put(k2, v2, false);
    }

    private V put(K k2, final V v2, final boolean bl2) {
        return (V)this.doTask(k2, new Task(new TaskOption[]{TaskOption.RESTRUCTURE_BEFORE, TaskOption.RESIZE}){

            protected V execute(Reference<K, V> reference, Entry<K, V> entry, Entries<V> entries) {
                if (entry != null) {
                    Object v22 = entry.getValue();
                    if (bl2) {
                        entry.setValue(v2);
                    }
                    return v22;
                }
                Assert.state(entries != null, "No entries segment");
                entries.add(v2);
                return null;
            }
        });
    }

    @Override
    public V remove(Object object) {
        return (V)this.doTask(object, new Task(new TaskOption[]{TaskOption.RESTRUCTURE_AFTER, TaskOption.SKIP_IF_EMPTY}){

            protected V execute(Reference<K, V> reference, Entry<K, V> entry) {
                if (entry != null) {
                    if (reference != null) {
                        reference.release();
                    }
                    return entry.value;
                }
                return null;
            }
        });
    }

    @Override
    public boolean remove(Object object, final Object object2) {
        Boolean bl2 = (Boolean)this.doTask(object, new Task(new TaskOption[]{TaskOption.RESTRUCTURE_AFTER, TaskOption.SKIP_IF_EMPTY}){

            protected Boolean execute(Reference<K, V> reference, Entry<K, V> entry) {
                if (entry != null && ObjectUtils.nullSafeEquals(entry.getValue(), object2)) {
                    if (reference != null) {
                        reference.release();
                    }
                    return true;
                }
                return false;
            }
        });
        return Boolean.TRUE.equals(bl2);
    }

    @Override
    public boolean replace(K k2, final V v2, final V v3) {
        Boolean bl2 = (Boolean)this.doTask(k2, new Task(new TaskOption[]{TaskOption.RESTRUCTURE_BEFORE, TaskOption.SKIP_IF_EMPTY}){

            protected Boolean execute(Reference<K, V> reference, Entry<K, V> entry) {
                if (entry != null && ObjectUtils.nullSafeEquals(entry.getValue(), v2)) {
                    entry.setValue(v3);
                    return true;
                }
                return false;
            }
        });
        return Boolean.TRUE.equals(bl2);
    }

    @Override
    public V replace(K k2, final V v2) {
        return (V)this.doTask(k2, new Task(new TaskOption[]{TaskOption.RESTRUCTURE_BEFORE, TaskOption.SKIP_IF_EMPTY}){

            protected V execute(Reference<K, V> reference, Entry<K, V> entry) {
                if (entry != null) {
                    Object v22 = entry.getValue();
                    entry.setValue(v2);
                    return v22;
                }
                return null;
            }
        });
    }

    @Override
    public void clear() {
        for (Segment segment : this.segments) {
            segment.clear();
        }
    }

    public void purgeUnreferencedEntries() {
        for (Segment segment : this.segments) {
            segment.restructureIfNecessary(false);
        }
    }

    @Override
    public int size() {
        int n2 = 0;
        for (Segment segment : this.segments) {
            n2 += segment.getCount();
        }
        return n2;
    }

    @Override
    public boolean isEmpty() {
        for (Segment segment : this.segments) {
            if (segment.getCount() <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        if (entrySet == null) {
            this.entrySet = entrySet = new EntrySet();
        }
        return entrySet;
    }

    private <T> T doTask(Object object, Task<T> task) {
        int n2 = this.getHash(object);
        return this.getSegmentForHash(n2).doTask(n2, object, task);
    }

    private Segment getSegmentForHash(int n2) {
        return this.segments[n2 >>> 32 - this.shift & this.segments.length - 1];
    }

    protected static int calculateShift(int n2, int n3) {
        int n4 = 0;
        int n5 = 1;
        while (n5 < n2 && n5 < n3) {
            n5 <<= 1;
            ++n4;
        }
        return n4;
    }

    private static final class WeakEntryReference<K, V>
    extends WeakReference<Entry<K, V>>
    implements Reference<K, V> {
        private final int hash;
        private final Reference<K, V> nextReference;

        public WeakEntryReference(Entry<K, V> entry, int n2, Reference<K, V> reference, ReferenceQueue<Entry<K, V>> referenceQueue) {
            super(entry, referenceQueue);
            this.hash = n2;
            this.nextReference = reference;
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public Reference<K, V> getNext() {
            return this.nextReference;
        }

        @Override
        public void release() {
            this.enqueue();
            this.clear();
        }
    }

    private static final class SoftEntryReference<K, V>
    extends SoftReference<Entry<K, V>>
    implements Reference<K, V> {
        private final int hash;
        private final Reference<K, V> nextReference;

        public SoftEntryReference(Entry<K, V> entry, int n2, Reference<K, V> reference, ReferenceQueue<Entry<K, V>> referenceQueue) {
            super(entry, referenceQueue);
            this.hash = n2;
            this.nextReference = reference;
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public Reference<K, V> getNext() {
            return this.nextReference;
        }

        @Override
        public void release() {
            this.enqueue();
            this.clear();
        }
    }

    protected class ReferenceManager {
        private final ReferenceQueue<Entry<K, V>> queue = new ReferenceQueue();

        protected ReferenceManager() {
        }

        public Reference<K, V> createReference(Entry<K, V> entry, int n2, Reference<K, V> reference) {
            if (ConcurrentReferenceHashMap.this.referenceType == ReferenceType.WEAK) {
                return new WeakEntryReference(entry, n2, reference, this.queue);
            }
            return new SoftEntryReference(entry, n2, reference, this.queue);
        }

        public Reference<K, V> pollForPurge() {
            return (Reference)((Object)this.queue.poll());
        }
    }

    protected static enum Restructure {
        WHEN_NECESSARY,
        NEVER;

    }

    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private int segmentIndex;
        private int referenceIndex;
        private Reference<K, V>[] references;
        private Reference<K, V> reference;
        private Entry<K, V> next;
        private Entry<K, V> last;

        public EntryIterator() {
            this.moveToNextSegment();
        }

        @Override
        public boolean hasNext() {
            this.getNextIfNecessary();
            return this.next != null;
        }

        @Override
        public Entry<K, V> next() {
            this.getNextIfNecessary();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.last = this.next;
            this.next = null;
            return this.last;
        }

        private void getNextIfNecessary() {
            while (this.next == null) {
                this.moveToNextReference();
                if (this.reference == null) {
                    return;
                }
                this.next = this.reference.get();
            }
        }

        private void moveToNextReference() {
            if (this.reference != null) {
                this.reference = this.reference.getNext();
            }
            while (this.reference == null && this.references != null) {
                if (this.referenceIndex >= this.references.length) {
                    this.moveToNextSegment();
                    this.referenceIndex = 0;
                    continue;
                }
                this.reference = this.references[this.referenceIndex];
                ++this.referenceIndex;
            }
        }

        private void moveToNextSegment() {
            this.reference = null;
            this.references = null;
            if (this.segmentIndex < ConcurrentReferenceHashMap.this.segments.length) {
                this.references = ConcurrentReferenceHashMap.this.segments[this.segmentIndex].references;
                ++this.segmentIndex;
            }
        }

        @Override
        public void remove() {
            Assert.state(this.last != null, "No element to remove");
            ConcurrentReferenceHashMap.this.remove(this.last.getKey());
            this.last = null;
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Entry entry;
                Map.Entry entry2 = (Map.Entry)object;
                Reference reference = ConcurrentReferenceHashMap.this.getReference(entry2.getKey(), Restructure.NEVER);
                Entry entry3 = entry = reference != null ? reference.get() : null;
                if (entry != null) {
                    return ObjectUtils.nullSafeEquals(entry2.getValue(), entry.getValue());
                }
            }
            return false;
        }

        @Override
        public boolean remove(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return ConcurrentReferenceHashMap.this.remove(entry.getKey(), entry.getValue());
            }
            return false;
        }

        @Override
        public int size() {
            return ConcurrentReferenceHashMap.this.size();
        }

        @Override
        public void clear() {
            ConcurrentReferenceHashMap.this.clear();
        }
    }

    private static interface Entries<V> {
        public void add(V var1);
    }

    private static enum TaskOption {
        RESTRUCTURE_BEFORE,
        RESTRUCTURE_AFTER,
        SKIP_IF_EMPTY,
        RESIZE;

    }

    private abstract class Task<T> {
        private final EnumSet<TaskOption> options;

        public Task(TaskOption ... taskOptionArray) {
            this.options = taskOptionArray.length == 0 ? EnumSet.noneOf(TaskOption.class) : EnumSet.of(taskOptionArray[0], taskOptionArray);
        }

        public boolean hasOption(TaskOption taskOption) {
            return this.options.contains((Object)taskOption);
        }

        protected T execute(Reference<K, V> reference, Entry<K, V> entry, Entries<V> entries) {
            return this.execute(reference, entry);
        }

        protected T execute(Reference<K, V> reference, Entry<K, V> entry) {
            return null;
        }
    }

    protected static final class Entry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private volatile V value;

        public Entry(K k2, V v2) {
            this.key = k2;
            this.value = v2;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v2) {
            V v3 = this.value;
            this.value = v2;
            return v3;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return ObjectUtils.nullSafeEquals(this.getKey(), entry.getKey()) && ObjectUtils.nullSafeEquals(this.getValue(), entry.getValue());
        }

        @Override
        public int hashCode() {
            return ObjectUtils.nullSafeHashCode(this.key) ^ ObjectUtils.nullSafeHashCode(this.value);
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    protected static interface Reference<K, V> {
        public Entry<K, V> get();

        public int getHash();

        public Reference<K, V> getNext();

        public void release();
    }

    protected final class Segment
    extends ReentrantLock {
        private final ReferenceManager referenceManager;
        private final int initialSize;
        private volatile Reference<K, V>[] references;
        private final AtomicInteger count = new AtomicInteger();
        private int resizeThreshold;

        public Segment(int n2, int n3) {
            this.referenceManager = ConcurrentReferenceHashMap.this.createReferenceManager();
            this.initialSize = n2;
            this.references = this.createReferenceArray(n2);
            this.resizeThreshold = n3;
        }

        public Reference<K, V> getReference(Object object, int n2, Restructure restructure) {
            if (restructure == Restructure.WHEN_NECESSARY) {
                this.restructureIfNecessary(false);
            }
            if (this.count.get() == 0) {
                return null;
            }
            Reference<K, V>[] referenceArray = this.references;
            int n3 = this.getIndex(n2, referenceArray);
            Reference reference = referenceArray[n3];
            return this.findInChain(reference, object, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T doTask(int n2, Object object, Task<T> task) {
            boolean bl2 = task.hasOption(TaskOption.RESIZE);
            if (task.hasOption(TaskOption.RESTRUCTURE_BEFORE)) {
                this.restructureIfNecessary(bl2);
            }
            if (task.hasOption(TaskOption.SKIP_IF_EMPTY) && this.count.get() == 0) {
                return task.execute(null, null, null);
            }
            this.lock();
            try {
                int n3 = this.getIndex(n2, this.references);
                Reference reference = this.references[n3];
                Reference reference2 = this.findInChain(reference, object, n2);
                Entry entry = reference2 != null ? reference2.get() : null;
                Entries<Object> entries = object2 -> {
                    Entry<Object, Object> entry = new Entry<Object, Object>(object, object2);
                    Reference reference2 = this.referenceManager.createReference(entry, n2, reference);
                    this.references[n3] = reference2;
                    this.count.incrementAndGet();
                };
                T t2 = task.execute(reference2, entry, entries);
                return t2;
            }
            finally {
                this.unlock();
                if (task.hasOption(TaskOption.RESTRUCTURE_AFTER)) {
                    this.restructureIfNecessary(bl2);
                }
            }
        }

        public void clear() {
            if (this.count.get() == 0) {
                return;
            }
            this.lock();
            try {
                this.references = this.createReferenceArray(this.initialSize);
                this.resizeThreshold = (int)((float)this.references.length * ConcurrentReferenceHashMap.this.getLoadFactor());
                this.count.set(0);
            }
            finally {
                this.unlock();
            }
        }

        protected final void restructureIfNecessary(boolean bl2) {
            int n2 = this.count.get();
            boolean bl3 = bl2 && n2 > 0 && n2 >= this.resizeThreshold;
            Reference reference = this.referenceManager.pollForPurge();
            if (reference != null || bl3) {
                this.restructure(bl2, reference);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void restructure(boolean bl2, Reference<K, V> reference) {
            this.lock();
            try {
                int n2 = this.count.get();
                Set set = Collections.emptySet();
                if (reference != null) {
                    set = new HashSet();
                    while (reference != null) {
                        set.add(reference);
                        reference = this.referenceManager.pollForPurge();
                    }
                }
                boolean bl3 = (n2 -= set.size()) > 0 && n2 >= this.resizeThreshold;
                boolean bl4 = false;
                int n3 = this.references.length;
                if (bl2 && bl3 && n3 < 0x40000000) {
                    n3 <<= 1;
                    bl4 = true;
                }
                Reference<K, V>[] referenceArray = bl4 ? this.createReferenceArray(n3) : this.references;
                for (int i2 = 0; i2 < this.references.length; ++i2) {
                    reference = this.references[i2];
                    if (!bl4) {
                        referenceArray[i2] = null;
                    }
                    while (reference != null) {
                        Entry entry;
                        if (!set.contains(reference) && (entry = reference.get()) != null) {
                            int n4 = this.getIndex(reference.getHash(), referenceArray);
                            referenceArray[n4] = this.referenceManager.createReference(entry, reference.getHash(), referenceArray[n4]);
                        }
                        reference = reference.getNext();
                    }
                }
                if (bl4) {
                    this.references = referenceArray;
                    this.resizeThreshold = (int)((float)this.references.length * ConcurrentReferenceHashMap.this.getLoadFactor());
                }
                this.count.set(Math.max(n2, 0));
            }
            finally {
                this.unlock();
            }
        }

        private Reference<K, V> findInChain(Reference<K, V> reference, Object object, int n2) {
            for (Reference reference2 = reference; reference2 != null; reference2 = reference2.getNext()) {
                Object k2;
                Entry entry;
                if (reference2.getHash() != n2 || (entry = reference2.get()) == null || !ObjectUtils.nullSafeEquals(k2 = entry.getKey(), object)) continue;
                return reference2;
            }
            return null;
        }

        private Reference<K, V>[] createReferenceArray(int n2) {
            return new Reference[n2];
        }

        private int getIndex(int n2, Reference<K, V>[] referenceArray) {
            return n2 & referenceArray.length - 1;
        }

        public final int getCount() {
            return this.count.get();
        }
    }

    public static enum ReferenceType {
        SOFT,
        WEAK;

    }
}

