/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.core;

import com.gradle.maven.extension.internal.dep.org.springframework.util.ClassUtils;
import java.lang.annotation.Annotation;

public abstract class KotlinDetector {
    private static final Class<? extends Annotation> kotlinMetadata;
    private static final boolean kotlinReflectPresent;

    public static boolean isKotlinReflectPresent() {
        return kotlinReflectPresent;
    }

    public static boolean isKotlinType(Class<?> clazz) {
        return kotlinMetadata != null && clazz.getDeclaredAnnotation(kotlinMetadata) != null;
    }

    static {
        Class<?> clazz;
        ClassLoader classLoader = KotlinDetector.class.getClassLoader();
        try {
            clazz = ClassUtils.forName("kotlin.Metadata", classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
        }
        kotlinMetadata = clazz;
        kotlinReflectPresent = ClassUtils.isPresent("kotlin.reflect.full.KClasses", classLoader);
    }
}

