/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.UpgradeRequest;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.util.QuoteUtil;
import java.net.HttpCookie;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class UpgradeRequestAdapter
implements UpgradeRequest {
    private URI requestURI;
    private List<String> subProtocols = new ArrayList<String>(1);
    private List<ExtensionConfig> extensions = new ArrayList<ExtensionConfig>(1);
    private List<HttpCookie> cookies = new ArrayList<HttpCookie>(1);
    private Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, List<String>> parameters = new HashMap<String, List<String>>(1);
    private String httpVersion;
    private String method;
    private String host;
    private boolean secure;

    protected UpgradeRequestAdapter() {
    }

    public UpgradeRequestAdapter(URI uRI) {
        this.setRequestURI(uRI);
    }

    public void addExtensions(ExtensionConfig ... extensionConfigArray) {
        Collections.addAll(this.extensions, extensionConfigArray);
    }

    public void clearHeaders() {
        this.headers.clear();
    }

    public String getHeader(String string) {
        List<String> list = this.headers.get(string);
        if (list == null) {
            return null;
        }
        int n2 = list.size();
        if (n2 <= 0) {
            return null;
        }
        if (n2 == 1) {
            return list.get(0);
        }
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : list) {
            if (bl2) {
                stringBuilder.append(", ");
            }
            QuoteUtil.quoteIfNeeded(stringBuilder, string2, "\"'\\\n\r\t\f\b%+ ;=");
            bl2 = true;
        }
        return stringBuilder.toString();
    }

    @Override
    public Map<String, List<String>> getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public String getProtocolVersion() {
        String string = this.getHeader("Sec-WebSocket-Version");
        if (string == null) {
            return "13";
        }
        return string;
    }

    public void setCookies(List<HttpCookie> list) {
        this.cookies.clear();
        if (list != null && !list.isEmpty()) {
            this.cookies.addAll(list);
        }
    }

    public void setHeader(String string, List<String> list) {
        this.headers.put(string, list);
    }

    public void setHeaders(Map<String, List<String>> map) {
        this.clearHeaders();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String string = entry.getKey();
            List<String> list = entry.getValue();
            this.setHeader(string, list);
        }
    }

    public void setHttpVersion(String string) {
        this.httpVersion = string;
    }

    public void setMethod(String string) {
        this.method = string;
    }

    protected void setParameterMap(Map<String, List<String>> map) {
        this.parameters.clear();
        this.parameters.putAll(map);
    }

    public void setRequestURI(URI uRI) {
        this.requestURI = uRI;
        String string = uRI.getScheme();
        if ("ws".equalsIgnoreCase(string)) {
            this.secure = false;
        } else if ("wss".equalsIgnoreCase(string)) {
            this.secure = true;
        } else {
            throw new IllegalArgumentException("URI scheme must be 'ws' or 'wss'");
        }
        this.host = this.requestURI.getHost();
        this.parameters.clear();
    }

    public void setSubProtocols(String ... stringArray) {
        this.subProtocols.clear();
        Collections.addAll(this.subProtocols, stringArray);
    }
}

