/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.BufferUtil;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Utf8Appendable;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Utf8StringBuilder;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.BadPayloadException;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.ProtocolException;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.StatusCode;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.Frame;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.frames.CloseFrame;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class CloseInfo {
    private int statusCode = 0;
    private byte[] reasonBytes;

    public CloseInfo() {
        this(1005, null);
    }

    public CloseInfo(ByteBuffer byteBuffer, boolean bl2) {
        this.statusCode = 1005;
        if (byteBuffer == null || byteBuffer.remaining() == 0) {
            return;
        }
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        if (byteBuffer2.remaining() == 1 && bl2) {
            throw new ProtocolException("Invalid 1 byte payload");
        }
        if (byteBuffer2.remaining() >= 2) {
            this.statusCode = 0;
            this.statusCode |= (byteBuffer2.get() & 0xFF) << 8;
            this.statusCode |= byteBuffer2.get() & 0xFF;
            if (bl2) {
                this.assertValidStatusCode(this.statusCode);
            }
            if (byteBuffer2.remaining() > 0) {
                int n2 = Math.min(byteBuffer2.remaining(), 123);
                this.reasonBytes = new byte[n2];
                byteBuffer2.get(this.reasonBytes, 0, n2);
                if (bl2) {
                    try {
                        Utf8StringBuilder utf8StringBuilder = new Utf8StringBuilder();
                        utf8StringBuilder.append(this.reasonBytes, 0, this.reasonBytes.length);
                    }
                    catch (Utf8Appendable.NotUtf8Exception notUtf8Exception) {
                        throw new BadPayloadException("Invalid Close Reason", (Throwable)notUtf8Exception);
                    }
                }
            }
        }
    }

    public CloseInfo(Frame frame) {
        this(frame.getPayload(), false);
    }

    public CloseInfo(Frame frame, boolean bl2) {
        this(frame.getPayload(), bl2);
    }

    public CloseInfo(int n2) {
        this(n2, null);
    }

    public CloseInfo(int n2, String string) {
        this.statusCode = n2;
        if (string != null) {
            byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
            if (byArray.length > 123) {
                this.reasonBytes = new byte[123];
                System.arraycopy(byArray, 0, this.reasonBytes, 0, 123);
            } else {
                this.reasonBytes = byArray;
            }
        }
    }

    private void assertValidStatusCode(int n2) {
        if (n2 <= 999 || n2 >= 5000) {
            throw new ProtocolException("Out of range close status code: " + n2);
        }
        if (n2 == 1006 || n2 == 1005 || n2 == 1015) {
            throw new ProtocolException("Frame forbidden close status code: " + n2);
        }
        if (n2 >= 1000 && n2 <= 2999 && !StatusCode.isTransmittable(n2)) {
            throw new ProtocolException("RFC6455 and IANA Undefined close status code: " + n2);
        }
    }

    private ByteBuffer asByteBuffer() {
        boolean bl2;
        if (this.statusCode == 1006 || this.statusCode == 1005 || this.statusCode == -1) {
            return null;
        }
        int n2 = 2;
        boolean bl3 = bl2 = this.reasonBytes != null && this.reasonBytes.length > 0;
        if (bl2) {
            n2 += this.reasonBytes.length;
        }
        ByteBuffer byteBuffer = BufferUtil.allocate(n2);
        BufferUtil.flipToFill(byteBuffer);
        byteBuffer.put((byte)(this.statusCode >>> 8 & 0xFF));
        byteBuffer.put((byte)(this.statusCode >>> 0 & 0xFF));
        if (bl2) {
            byteBuffer.put(this.reasonBytes, 0, this.reasonBytes.length);
        }
        BufferUtil.flipToFlush(byteBuffer, 0);
        return byteBuffer;
    }

    public CloseFrame asFrame() {
        CloseFrame closeFrame = new CloseFrame();
        closeFrame.setFin(true);
        if (this.statusCode != 1006 && this.statusCode != 1005 && this.statusCode != 1015) {
            this.assertValidStatusCode(this.statusCode);
            closeFrame.setPayload(this.asByteBuffer());
        }
        return closeFrame;
    }

    public String getReason() {
        if (this.reasonBytes == null) {
            return null;
        }
        return new String(this.reasonBytes, StandardCharsets.UTF_8);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String toString() {
        return String.format("CloseInfo[code=%d,reason=%s]", this.statusCode, this.getReason());
    }
}

