/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.client;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpField;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpFields;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.MultiMap;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.StringUtil;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.UrlEncoded;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.client.WebSocketUpgradeRequest;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.UpgradeRequestAdapter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;

public class ClientUpgradeRequest
extends UpgradeRequestAdapter {
    private static final Set<String> FORBIDDEN_HEADERS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private final String key = this.genRandomKey();

    public ClientUpgradeRequest() {
    }

    protected ClientUpgradeRequest(URI uRI) {
        super(uRI);
    }

    public ClientUpgradeRequest(WebSocketUpgradeRequest webSocketUpgradeRequest) {
        this(webSocketUpgradeRequest.getURI());
        this.setCookies(webSocketUpgradeRequest.getCookies());
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        HttpFields httpFields = webSocketUpgradeRequest.getHeaders();
        for (HttpField httpField : httpFields) {
            String string = httpField.getName();
            ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.addAll(Arrays.asList(httpField.getValues()));
            hashMap.put(string, arrayList);
            if (string.equalsIgnoreCase("Sec-WebSocket-Protocol")) {
                for (String string2 : httpField.getValue().split(",")) {
                    this.setSubProtocols(string2);
                }
            }
            if (!string.equalsIgnoreCase("Sec-WebSocket-Extensions")) continue;
            for (ExtensionConfig extensionConfig : ExtensionConfig.parseList(httpField.getValues())) {
                this.addExtensions(extensionConfig);
            }
        }
        super.setHeaders(hashMap);
        this.setHttpVersion(webSocketUpgradeRequest.getVersion().toString());
        this.setMethod(webSocketUpgradeRequest.getMethod());
    }

    private final String genRandomKey() {
        byte[] byArray = new byte[16];
        ThreadLocalRandom.current().nextBytes(byArray);
        return Base64.getEncoder().encodeToString(byArray);
    }

    @Override
    public void setRequestURI(URI uRI) {
        super.setRequestURI(uRI);
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        String string = uRI.getRawQuery();
        if (StringUtil.isNotBlank(string)) {
            MultiMap<String> multiMap = new MultiMap<String>();
            UrlEncoded.decodeTo(string, multiMap, StandardCharsets.UTF_8);
            for (String string2 : multiMap.keySet()) {
                List<String> list = multiMap.getValues(string2);
                if (list == null) {
                    hashMap.put(string2, new ArrayList());
                    continue;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.addAll(list);
                hashMap.put(string2, arrayList);
            }
            super.setParameterMap(hashMap);
        }
    }

    static {
        FORBIDDEN_HEADERS.add("cookie");
        FORBIDDEN_HEADERS.add("upgrade");
        FORBIDDEN_HEADERS.add("host");
        FORBIDDEN_HEADERS.add("connection");
        FORBIDDEN_HEADERS.add("sec-websocket-key");
        FORBIDDEN_HEADERS.add("sec-websocket-extensions");
        FORBIDDEN_HEADERS.add("sec-websocket-accept");
        FORBIDDEN_HEADERS.add("sec-websocket-protocol");
        FORBIDDEN_HEADERS.add("sec-websocket-version");
        FORBIDDEN_HEADERS.add("pragma");
        FORBIDDEN_HEADERS.add("cache-control");
    }
}

