/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;

public final class WSURI {
    public static URI toWebsocket(URI uRI) throws URISyntaxException {
        Objects.requireNonNull(uRI, "Input URI must not be null");
        String string = uRI.getScheme();
        if ("ws".equalsIgnoreCase(string) || "wss".equalsIgnoreCase(string)) {
            return uRI;
        }
        if ("http".equalsIgnoreCase(string)) {
            return new URI("ws" + uRI.toString().substring(string.length()));
        }
        if ("https".equalsIgnoreCase(string)) {
            return new URI("wss" + uRI.toString().substring(string.length()));
        }
        throw new URISyntaxException(uRI.toString(), "Unrecognized HTTP scheme");
    }
}

