/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.ssl;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;

public class AliasedX509ExtendedKeyManager
extends X509ExtendedKeyManager {
    private final String _alias;
    private final X509ExtendedKeyManager _delegate;

    public AliasedX509ExtendedKeyManager(X509ExtendedKeyManager x509ExtendedKeyManager, String string) {
        this._alias = string;
        this._delegate = x509ExtendedKeyManager;
    }

    @Override
    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        if (this._alias == null) {
            return this._delegate.chooseClientAlias(stringArray, principalArray, socket);
        }
        for (String string : stringArray) {
            String[] stringArray2 = this._delegate.getClientAliases(string, principalArray);
            if (stringArray2 == null) continue;
            for (String string2 : stringArray2) {
                if (!this._alias.equals(string2)) continue;
                return this._alias;
            }
        }
        return null;
    }

    @Override
    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        if (this._alias == null) {
            return this._delegate.chooseServerAlias(string, principalArray, socket);
        }
        String[] stringArray = this._delegate.getServerAliases(string, principalArray);
        if (stringArray != null) {
            for (String string2 : stringArray) {
                if (!this._alias.equals(string2)) continue;
                return this._alias;
            }
        }
        return null;
    }

    @Override
    public String[] getClientAliases(String string, Principal[] principalArray) {
        return this._delegate.getClientAliases(string, principalArray);
    }

    @Override
    public String[] getServerAliases(String string, Principal[] principalArray) {
        return this._delegate.getServerAliases(string, principalArray);
    }

    @Override
    public X509Certificate[] getCertificateChain(String string) {
        return this._delegate.getCertificateChain(string);
    }

    @Override
    public PrivateKey getPrivateKey(String string) {
        return this._delegate.getPrivateKey(string);
    }

    @Override
    public String chooseEngineServerAlias(String string, Principal[] principalArray, SSLEngine sSLEngine) {
        if (this._alias == null) {
            return this._delegate.chooseEngineServerAlias(string, principalArray, sSLEngine);
        }
        String[] stringArray = this._delegate.getServerAliases(string, principalArray);
        if (stringArray != null) {
            for (String string2 : stringArray) {
                if (!this._alias.equals(string2)) continue;
                return this._alias;
            }
        }
        return null;
    }

    @Override
    public String chooseEngineClientAlias(String[] stringArray, Principal[] principalArray, SSLEngine sSLEngine) {
        if (this._alias == null) {
            return this._delegate.chooseEngineClientAlias(stringArray, principalArray, sSLEngine);
        }
        for (String string : stringArray) {
            String[] stringArray2 = this._delegate.getClientAliases(string, principalArray);
            if (stringArray2 == null) continue;
            for (String string2 : stringArray2) {
                if (!this._alias.equals(string2)) continue;
                return this._alias;
            }
        }
        return null;
    }
}

