/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.resource;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.URIUtil;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.resource.JarResource;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class JarFileResource
extends JarResource {
    private static final Logger LOG = Log.getLogger(JarFileResource.class);
    private JarFile _jarFile;
    private File _file;
    private String[] _list;
    private JarEntry _entry;
    private boolean _directory;
    private String _jarUrl;
    private String _path;
    private boolean _exists;

    protected JarFileResource(URL uRL, boolean bl2) {
        super(uRL, bl2);
    }

    @Override
    public synchronized void close() {
        this._exists = false;
        this._list = null;
        this._entry = null;
        this._file = null;
        if (!this.getUseCaches() && this._jarFile != null) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Closing JarFile " + this._jarFile.getName(), new Object[0]);
                }
                this._jarFile.close();
            }
            catch (IOException iOException) {
                LOG.ignore(iOException);
            }
        }
        this._jarFile = null;
        super.close();
    }

    @Override
    protected synchronized boolean checkConnection() {
        try {
            super.checkConnection();
        }
        finally {
            if (this._jarConnection == null) {
                this._entry = null;
                this._file = null;
                this._jarFile = null;
                this._list = null;
            }
        }
        return this._jarFile != null;
    }

    @Override
    protected synchronized void newConnection() throws IOException {
        super.newConnection();
        this._entry = null;
        this._file = null;
        this._jarFile = null;
        this._list = null;
        int n2 = this._urlString.lastIndexOf("!/");
        this._jarUrl = this._urlString.substring(0, n2 + 2);
        this._path = URIUtil.decodePath(this._urlString.substring(n2 + 2));
        if (this._path.length() == 0) {
            this._path = null;
        }
        this._jarFile = this._jarConnection.getJarFile();
        this._file = new File(this._jarFile.getName());
    }

    @Override
    public boolean exists() {
        Object object;
        if (this._exists) {
            return true;
        }
        if (this._urlString.endsWith("!/")) {
            String string = this._urlString.substring(4, this._urlString.length() - 2);
            try {
                return JarFileResource.newResource(string).exists();
            }
            catch (Exception exception) {
                LOG.ignore(exception);
                return false;
            }
        }
        boolean bl2 = this.checkConnection();
        if (this._jarUrl != null && this._path == null) {
            this._directory = bl2;
            return true;
        }
        boolean bl3 = false;
        JarFile jarFile = null;
        if (bl2) {
            jarFile = this._jarFile;
        } else {
            try {
                object = (JarURLConnection)new URL(this._jarUrl).openConnection();
                ((URLConnection)object).setUseCaches(this.getUseCaches());
                jarFile = ((JarURLConnection)object).getJarFile();
                bl3 = !this.getUseCaches();
            }
            catch (Exception exception) {
                LOG.ignore(exception);
            }
        }
        if (jarFile != null && this._entry == null && !this._directory) {
            object = jarFile.getJarEntry(this._path);
            if (object == null) {
                this._exists = false;
            } else if (((ZipEntry)object).isDirectory()) {
                this._directory = true;
                this._entry = object;
            } else {
                JarEntry jarEntry = jarFile.getJarEntry(this._path + '/');
                if (jarEntry != null) {
                    this._directory = true;
                    this._entry = jarEntry;
                } else {
                    this._directory = false;
                    this._entry = object;
                }
            }
        }
        if (bl3 && jarFile != null) {
            try {
                jarFile.close();
            }
            catch (IOException iOException) {
                LOG.ignore(iOException);
            }
        }
        this._exists = this._directory || this._entry != null;
        return this._exists;
    }
}

