/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.AbstractEndPoint;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.EofException;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.ManagedSelector;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.BufferUtil;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.thread.Invocable;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.thread.Scheduler;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

public abstract class ChannelEndPoint
extends AbstractEndPoint
implements ManagedSelector.Selectable {
    private static final Logger LOG = Log.getLogger(ChannelEndPoint.class);
    private final SocketChannel _channel;
    private final ManagedSelector _selector;
    private SelectionKey _key;
    private boolean _updatePending;
    private int _currentInterestOps;
    private int _desiredInterestOps;
    private final ManagedSelector.SelectorUpdate _updateKeyAction = this::updateKeyAction;
    private final Runnable _runFillable = new RunnableCloseable("runFillable"){

        @Override
        public Invocable.InvocationType getInvocationType() {
            return ChannelEndPoint.this.getFillInterest().getCallbackInvocationType();
        }

        @Override
        public void run() {
            ChannelEndPoint.this.getFillInterest().fillable();
        }
    };
    private final Runnable _runCompleteWrite = new RunnableCloseable("runCompleteWrite"){

        @Override
        public Invocable.InvocationType getInvocationType() {
            return ChannelEndPoint.this.getWriteFlusher().getCallbackInvocationType();
        }

        @Override
        public void run() {
            ChannelEndPoint.this.getWriteFlusher().completeWrite();
        }

        @Override
        public String toString() {
            return String.format("CEP:%s:%s:%s->%s", new Object[]{ChannelEndPoint.this, this._operation, this.getInvocationType(), ChannelEndPoint.this.getWriteFlusher()});
        }
    };
    private final Runnable _runCompleteWriteFillable = new RunnableCloseable("runCompleteWriteFillable"){

        @Override
        public Invocable.InvocationType getInvocationType() {
            Invocable.InvocationType invocationType;
            Invocable.InvocationType invocationType2 = ChannelEndPoint.this.getFillInterest().getCallbackInvocationType();
            if (invocationType2 == (invocationType = ChannelEndPoint.this.getWriteFlusher().getCallbackInvocationType())) {
                return invocationType2;
            }
            if (invocationType2 == Invocable.InvocationType.EITHER && invocationType == Invocable.InvocationType.NON_BLOCKING) {
                return Invocable.InvocationType.EITHER;
            }
            if (invocationType2 == Invocable.InvocationType.NON_BLOCKING && invocationType == Invocable.InvocationType.EITHER) {
                return Invocable.InvocationType.EITHER;
            }
            return Invocable.InvocationType.BLOCKING;
        }

        @Override
        public void run() {
            ChannelEndPoint.this.getWriteFlusher().completeWrite();
            ChannelEndPoint.this.getFillInterest().fillable();
        }
    };

    public ChannelEndPoint(SocketChannel socketChannel, ManagedSelector managedSelector, SelectionKey selectionKey, Scheduler scheduler) {
        super(scheduler);
        this._channel = socketChannel;
        this._selector = managedSelector;
        this._key = selectionKey;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this._channel.socket().getLocalSocketAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this._channel.socket().getRemoteSocketAddress();
    }

    @Override
    public boolean isOpen() {
        return this._channel.isOpen();
    }

    @Override
    protected void doShutdownOutput() {
        try {
            Socket socket = this._channel.socket();
            if (!socket.isOutputShutdown()) {
                socket.shutdownOutput();
            }
        }
        catch (IOException iOException) {
            LOG.debug(iOException);
        }
    }

    @Override
    public void doClose() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("doClose {}", this);
        }
        try {
            this._key.cancel();
            this._channel.close();
        }
        catch (IOException iOException) {
            LOG.debug(iOException);
        }
        finally {
            super.doClose();
        }
    }

    @Override
    public void onClose() {
        try {
            super.onClose();
        }
        finally {
            if (this._selector != null) {
                this._selector.destroyEndPoint(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int fill(ByteBuffer byteBuffer) throws IOException {
        int n2;
        if (this.isInputShutdown()) {
            return -1;
        }
        int n3 = BufferUtil.flipToFill(byteBuffer);
        try {
            n2 = this._channel.read(byteBuffer);
            if (n2 > 0) {
                this.notIdle();
            } else if (n2 == -1) {
                this.shutdownInput();
            }
        }
        catch (IOException iOException) {
            LOG.debug(iOException);
            this.shutdownInput();
            n2 = -1;
        }
        finally {
            BufferUtil.flipToFlush(byteBuffer, n3);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("filled {} {}", n2, BufferUtil.toDetailString(byteBuffer));
        }
        return n2;
    }

    @Override
    public boolean flush(ByteBuffer ... byteBufferArray) throws IOException {
        long l2;
        try {
            l2 = this._channel.write(byteBufferArray);
            if (LOG.isDebugEnabled()) {
                LOG.debug("flushed {} {}", l2, this);
            }
        }
        catch (IOException iOException) {
            throw new EofException(iOException);
        }
        if (l2 > 0L) {
            this.notIdle();
        }
        for (ByteBuffer byteBuffer : byteBufferArray) {
            if (BufferUtil.isEmpty(byteBuffer)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void needsFillInterest() {
        this.changeInterests(1);
    }

    @Override
    protected void onIncompleteFlush() {
        this.changeInterests(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Runnable onSelected() {
        Runnable runnable;
        boolean bl2;
        int n2;
        int n3;
        int n4 = this._key.readyOps();
        ChannelEndPoint channelEndPoint = this;
        synchronized (channelEndPoint) {
            this._updatePending = true;
            n3 = this._desiredInterestOps;
            this._desiredInterestOps = n2 = n3 & ~n4;
        }
        boolean bl3 = (n4 & 1) != 0;
        boolean bl4 = bl2 = (n4 & 4) != 0;
        if (LOG.isDebugEnabled()) {
            LOG.debug("onSelected {}->{} r={} w={} for {}", n3, n2, bl3, bl2, this);
        }
        Runnable runnable2 = bl3 ? (bl2 ? this._runCompleteWriteFillable : this._runFillable) : (runnable = bl2 ? this._runCompleteWrite : null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("task {}", runnable);
        }
        return runnable;
    }

    private void updateKeyAction(Selector selector) {
        this.updateKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateKey() {
        try {
            int n2;
            int n3;
            ChannelEndPoint channelEndPoint = this;
            synchronized (channelEndPoint) {
                this._updatePending = false;
                n3 = this._currentInterestOps;
                n2 = this._desiredInterestOps;
                if (n3 != n2) {
                    this._currentInterestOps = n2;
                    this._key.interestOps(n2);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Key interests updated {} -> {} on {}", n3, n2, this);
            }
        }
        catch (CancelledKeyException cancelledKeyException) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring key update for cancelled key {}", this, cancelledKeyException);
            }
            this.close();
        }
        catch (Throwable throwable) {
            LOG.warn("Ignoring key update for {}", this, throwable);
            this.close();
        }
    }

    @Override
    public void replaceKey(SelectionKey selectionKey) {
        this._key = selectionKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeInterests(int n2) {
        int n3;
        int n4;
        boolean bl2;
        ChannelEndPoint channelEndPoint = this;
        synchronized (channelEndPoint) {
            bl2 = this._updatePending;
            n4 = this._desiredInterestOps;
            n3 = n4 | n2;
            if (n3 != n4) {
                this._desiredInterestOps = n3;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("changeInterests p={} {}->{} for {}", bl2, n4, n3, this);
        }
        if (!bl2 && this._selector != null) {
            this._selector.submit(this._updateKeyAction);
        }
    }

    @Override
    public String toEndPointString() {
        return String.format("%s{io=%d/%d,kio=%d,kro=%d}", super.toEndPointString(), this._currentInterestOps, this._desiredInterestOps, ManagedSelector.safeInterestOps(this._key), ManagedSelector.safeReadyOps(this._key));
    }

    private abstract class RunnableCloseable
    extends RunnableTask
    implements Closeable {
        protected RunnableCloseable(String string) {
            super(string);
        }

        @Override
        public void close() {
            try {
                ChannelEndPoint.this.close();
            }
            catch (Throwable throwable) {
                LOG.warn(throwable);
            }
        }
    }

    private abstract class RunnableTask
    implements Runnable,
    Invocable {
        final String _operation;

        protected RunnableTask(String string) {
            this._operation = string;
        }

        public String toString() {
            return String.format("CEP:%s:%s:%s", new Object[]{ChannelEndPoint.this, this._operation, this.getInvocationType()});
        }
    }
}

