/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpComplianceSection;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpURI;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum HttpCompliance {
    LEGACY(HttpCompliance.sectionsBySpec("0,METHOD_CASE_SENSITIVE")),
    RFC2616_LEGACY(HttpCompliance.sectionsBySpec("RFC2616,-FIELD_COLON,-METHOD_CASE_SENSITIVE,-TRANSFER_ENCODING_WITH_CONTENT_LENGTH,-MULTIPLE_CONTENT_LENGTHS")),
    RFC2616(HttpCompliance.sectionsBySpec("RFC2616")),
    RFC7230_LEGACY(HttpCompliance.sectionsBySpec("RFC7230,-METHOD_CASE_SENSITIVE")),
    RFC7230(HttpCompliance.sectionsBySpec("RFC7230")),
    RFC7230_NO_AMBIGUOUS_URIS(HttpCompliance.sectionsBySpec("RFC7230,NO_AMBIGUOUS_PATH_SEGMENTS,NO_AMBIGUOUS_PATH_SEPARATORS")),
    CUSTOM0(HttpCompliance.sectionsByProperty("CUSTOM0")),
    CUSTOM1(HttpCompliance.sectionsByProperty("CUSTOM1")),
    CUSTOM2(HttpCompliance.sectionsByProperty("CUSTOM2")),
    CUSTOM3(HttpCompliance.sectionsByProperty("CUSTOM3"));

    public static final String VIOLATIONS_ATTR = "com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.compliance.violations";
    private static final Map<HttpComplianceSection, HttpCompliance> __required;
    private final EnumSet<HttpComplianceSection> _sections;
    private static final EnumMap<HttpURI.Violation, HttpComplianceSection> __uriViolations;

    private static EnumSet<HttpComplianceSection> sectionsByProperty(String string) {
        String string2 = System.getProperty(HttpCompliance.class.getName() + string);
        return HttpCompliance.sectionsBySpec(string2 == null ? "*" : string2);
    }

    static EnumSet<HttpComplianceSection> sectionsBySpec(String string) {
        EnumSet<HttpComplianceSection> enumSet;
        String[] stringArray = string.split("\\s*,\\s*");
        int n2 = 0;
        switch (stringArray[n2]) {
            case "0": {
                enumSet = EnumSet.noneOf(HttpComplianceSection.class);
                ++n2;
                break;
            }
            case "RFC2616": {
                ++n2;
                enumSet = EnumSet.complementOf(EnumSet.of(HttpComplianceSection.NO_FIELD_FOLDING, new HttpComplianceSection[]{HttpComplianceSection.NO_HTTP_0_9, HttpComplianceSection.NO_AMBIGUOUS_PATH_SEGMENTS, HttpComplianceSection.NO_AMBIGUOUS_PATH_SEPARATORS, HttpComplianceSection.NO_UTF16_ENCODINGS, HttpComplianceSection.NO_AMBIGUOUS_EMPTY_SEGMENT, HttpComplianceSection.NO_AMBIGUOUS_PATH_ENCODING}));
                break;
            }
            case "*": 
            case "RFC7230": {
                ++n2;
                enumSet = EnumSet.complementOf(EnumSet.of(HttpComplianceSection.NO_AMBIGUOUS_PATH_SEGMENTS, HttpComplianceSection.NO_AMBIGUOUS_PATH_SEPARATORS, HttpComplianceSection.NO_UTF16_ENCODINGS, HttpComplianceSection.NO_AMBIGUOUS_EMPTY_SEGMENT, HttpComplianceSection.NO_AMBIGUOUS_PATH_ENCODING));
                break;
            }
            default: {
                enumSet = EnumSet.noneOf(HttpComplianceSection.class);
            }
        }
        while (n2 < stringArray.length) {
            String string2;
            int n3;
            if ((n3 = (int)((string2 = stringArray[n2++]).startsWith("-") ? 1 : 0)) != 0) {
                string2 = string2.substring(1);
            }
            HttpComplianceSection httpComplianceSection = HttpComplianceSection.valueOf(string2);
            if (n3 != 0) {
                enumSet.remove((Object)httpComplianceSection);
                continue;
            }
            enumSet.add(httpComplianceSection);
        }
        return enumSet;
    }

    public static HttpCompliance requiredCompliance(HttpComplianceSection httpComplianceSection) {
        return __required.get((Object)httpComplianceSection);
    }

    private HttpCompliance(EnumSet<HttpComplianceSection> enumSet) {
        this._sections = enumSet;
    }

    public EnumSet<HttpComplianceSection> sections() {
        return this._sections;
    }

    static {
        __required = new HashMap<HttpComplianceSection, HttpCompliance>();
        block8: for (HttpComplianceSection enum_ : HttpComplianceSection.values()) {
            for (HttpCompliance httpCompliance : HttpCompliance.values()) {
                if (!httpCompliance.sections().contains((Object)enum_)) continue;
                __required.put(enum_, httpCompliance);
                continue block8;
            }
        }
        __uriViolations = new EnumMap(HttpURI.Violation.class);
        block10: for (Enum enum_ : HttpURI.Violation.values()) {
            switch (1.$SwitchMap$org$eclipse$jetty$http$HttpURI$Violation[enum_.ordinal()]) {
                case 1: {
                    __uriViolations.put((HttpURI.Violation)enum_, HttpComplianceSection.NO_AMBIGUOUS_PATH_SEPARATORS);
                    continue block10;
                }
                case 2: {
                    __uriViolations.put((HttpURI.Violation)enum_, HttpComplianceSection.NO_AMBIGUOUS_PATH_SEGMENTS);
                    continue block10;
                }
                case 3: {
                    __uriViolations.put((HttpURI.Violation)enum_, HttpComplianceSection.NO_AMBIGUOUS_PATH_PARAMETERS);
                    continue block10;
                }
                case 4: {
                    __uriViolations.put((HttpURI.Violation)enum_, HttpComplianceSection.NO_AMBIGUOUS_PATH_ENCODING);
                    continue block10;
                }
                case 5: {
                    __uriViolations.put((HttpURI.Violation)enum_, HttpComplianceSection.NO_AMBIGUOUS_EMPTY_SEGMENT);
                    continue block10;
                }
                case 6: {
                    __uriViolations.put((HttpURI.Violation)enum_, HttpComplianceSection.NO_UTF16_ENCODINGS);
                    continue block10;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }
}

