/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.Synchronizable;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.ContentProvider;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.BufferUtil;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Callback;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.IO;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;

public class HttpContent
implements Closeable,
Callback {
    private static final Logger LOG = Log.getLogger(HttpContent.class);
    private static final ByteBuffer AFTER = ByteBuffer.allocate(0);
    private static final ByteBuffer CLOSE = ByteBuffer.allocate(0);
    private final ContentProvider provider;
    private final Iterator<ByteBuffer> iterator;
    private ByteBuffer buffer;
    private ByteBuffer content;
    private boolean last;

    public HttpContent(ContentProvider contentProvider) {
        this.provider = contentProvider;
        this.iterator = contentProvider == null ? Collections.emptyIterator() : contentProvider.iterator();
    }

    private static boolean isTheCloseBuffer(ByteBuffer byteBuffer) {
        boolean bl2 = byteBuffer == CLOSE;
        return bl2;
    }

    public boolean hasContent() {
        return this.provider != null;
    }

    public boolean isLast() {
        return this.last;
    }

    public ByteBuffer getByteBuffer() {
        return this.buffer;
    }

    public ByteBuffer getContent() {
        return this.content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean advance() {
        if (this.iterator instanceof Synchronizable) {
            Object object = ((Synchronizable)((Object)this.iterator)).getLock();
            synchronized (object) {
                return this.advance(this.iterator);
            }
        }
        return this.advance(this.iterator);
    }

    private boolean advance(Iterator<ByteBuffer> iterator) {
        boolean bl2 = iterator.hasNext();
        ByteBuffer byteBuffer = bl2 ? iterator.next() : null;
        boolean bl3 = bl2 && iterator.hasNext();
        boolean bl4 = this.last;
        boolean bl5 = this.last = !bl3;
        if (bl2) {
            this.buffer = byteBuffer;
            ByteBuffer byteBuffer2 = this.content = byteBuffer == null ? null : byteBuffer.slice();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Advanced content to {} chunk {}", bl3 ? "next" : "last", String.valueOf(byteBuffer));
            }
            return byteBuffer != null;
        }
        if (bl4) {
            this.buffer = this.content = AFTER;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Advanced content past last chunk", new Object[0]);
            }
        } else {
            this.buffer = this.content = CLOSE;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Advanced content to last chunk", new Object[0]);
            }
        }
        return false;
    }

    public boolean isConsumed() {
        return this.buffer == AFTER;
    }

    @Override
    public void succeeded() {
        if (this.isConsumed()) {
            return;
        }
        if (HttpContent.isTheCloseBuffer(this.buffer)) {
            return;
        }
        if (this.iterator instanceof Callback) {
            ((Callback)((Object)this.iterator)).succeeded();
        }
    }

    @Override
    public void failed(Throwable throwable) {
        if (this.isConsumed()) {
            return;
        }
        if (HttpContent.isTheCloseBuffer(this.buffer)) {
            return;
        }
        if (this.iterator instanceof Callback) {
            ((Callback)((Object)this.iterator)).failed(throwable);
        }
    }

    @Override
    public void close() {
        if (this.iterator instanceof Closeable) {
            IO.close((Closeable)((Object)this.iterator));
        }
    }

    public String toString() {
        return String.format("%s@%x - has=%b,last=%b,consumed=%b,buffer=%s", this.getClass().getSimpleName(), this.hashCode(), this.hasContent(), this.isLast(), this.isConsumed(), BufferUtil.toDetailString(this.getContent()));
    }
}

