/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.http.impl.auth;

import com.gradle.maven.extension.internal.dep.org.apache.commons.codec.binary.Base64;
import com.gradle.maven.extension.internal.dep.org.apache.http.Consts;
import com.gradle.maven.extension.internal.dep.org.apache.http.Header;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpRequest;
import com.gradle.maven.extension.internal.dep.org.apache.http.auth.AuthenticationException;
import com.gradle.maven.extension.internal.dep.org.apache.http.auth.Credentials;
import com.gradle.maven.extension.internal.dep.org.apache.http.auth.MalformedChallengeException;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.auth.RFC2617Scheme;
import com.gradle.maven.extension.internal.dep.org.apache.http.message.BufferedHeader;
import com.gradle.maven.extension.internal.dep.org.apache.http.protocol.BasicHttpContext;
import com.gradle.maven.extension.internal.dep.org.apache.http.protocol.HttpContext;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.Args;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.CharArrayBuffer;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.EncodingUtils;
import java.nio.charset.Charset;

public class BasicScheme
extends RFC2617Scheme {
    private boolean complete = false;

    public BasicScheme(Charset charset) {
        super(charset);
    }

    public BasicScheme() {
        this(Consts.ASCII);
    }

    @Override
    public String getSchemeName() {
        return "basic";
    }

    @Override
    public void processChallenge(Header header) throws MalformedChallengeException {
        super.processChallenge(header);
        this.complete = true;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public boolean isConnectionBased() {
        return false;
    }

    @Override
    @Deprecated
    public Header authenticate(Credentials credentials, HttpRequest httpRequest) throws AuthenticationException {
        return this.authenticate(credentials, httpRequest, new BasicHttpContext());
    }

    @Override
    public Header authenticate(Credentials credentials, HttpRequest httpRequest, HttpContext httpContext) throws AuthenticationException {
        Args.notNull(credentials, "Credentials");
        Args.notNull(httpRequest, "HTTP request");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(credentials.getUserPrincipal().getName());
        stringBuilder.append(":");
        stringBuilder.append(credentials.getPassword() == null ? "null" : credentials.getPassword());
        Base64 base64 = new Base64(0);
        byte[] byArray = base64.encode(EncodingUtils.getBytes(stringBuilder.toString(), this.getCredentialsCharset(httpRequest)));
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(32);
        if (this.isProxy()) {
            charArrayBuffer.append("Proxy-Authorization");
        } else {
            charArrayBuffer.append("Authorization");
        }
        charArrayBuffer.append(": Basic ");
        charArrayBuffer.append(byArray, 0, byArray.length);
        return new BufferedHeader(charArrayBuffer);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("BASIC [complete=").append(this.complete).append("]");
        return stringBuilder.toString();
    }
}

