/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.http.impl.auth;

import com.gradle.maven.extension.internal.dep.org.apache.http.FormattedHeader;
import com.gradle.maven.extension.internal.dep.org.apache.http.Header;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpRequest;
import com.gradle.maven.extension.internal.dep.org.apache.http.auth.AuthenticationException;
import com.gradle.maven.extension.internal.dep.org.apache.http.auth.ChallengeState;
import com.gradle.maven.extension.internal.dep.org.apache.http.auth.ContextAwareAuthScheme;
import com.gradle.maven.extension.internal.dep.org.apache.http.auth.Credentials;
import com.gradle.maven.extension.internal.dep.org.apache.http.auth.MalformedChallengeException;
import com.gradle.maven.extension.internal.dep.org.apache.http.protocol.HTTP;
import com.gradle.maven.extension.internal.dep.org.apache.http.protocol.HttpContext;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.Args;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.CharArrayBuffer;
import java.util.Locale;

public abstract class AuthSchemeBase
implements ContextAwareAuthScheme {
    protected ChallengeState challengeState;

    @Override
    public void processChallenge(Header header) throws MalformedChallengeException {
        int n2;
        CharArrayBuffer charArrayBuffer;
        Args.notNull(header, "Header");
        String string = header.getName();
        if (string.equalsIgnoreCase("WWW-Authenticate")) {
            this.challengeState = ChallengeState.TARGET;
        } else if (string.equalsIgnoreCase("Proxy-Authenticate")) {
            this.challengeState = ChallengeState.PROXY;
        } else {
            throw new MalformedChallengeException("Unexpected header name: " + string);
        }
        if (header instanceof FormattedHeader) {
            charArrayBuffer = ((FormattedHeader)header).getBuffer();
            n2 = ((FormattedHeader)header).getValuePos();
        } else {
            String string2 = header.getValue();
            if (string2 == null) {
                throw new MalformedChallengeException("Header value is null");
            }
            charArrayBuffer = new CharArrayBuffer(string2.length());
            charArrayBuffer.append(string2);
            n2 = 0;
        }
        while (n2 < charArrayBuffer.length() && HTTP.isWhitespace(charArrayBuffer.charAt(n2))) {
            ++n2;
        }
        int n3 = n2;
        while (n2 < charArrayBuffer.length() && !HTTP.isWhitespace(charArrayBuffer.charAt(n2))) {
            ++n2;
        }
        int n4 = n2;
        String string3 = charArrayBuffer.substring(n3, n4);
        if (!string3.equalsIgnoreCase(this.getSchemeName())) {
            throw new MalformedChallengeException("Invalid scheme identifier: " + string3);
        }
        this.parseChallenge(charArrayBuffer, n2, charArrayBuffer.length());
    }

    @Override
    public Header authenticate(Credentials credentials, HttpRequest httpRequest, HttpContext httpContext) throws AuthenticationException {
        return this.authenticate(credentials, httpRequest);
    }

    protected abstract void parseChallenge(CharArrayBuffer var1, int var2, int var3) throws MalformedChallengeException;

    public boolean isProxy() {
        return this.challengeState != null && this.challengeState == ChallengeState.PROXY;
    }

    public String toString() {
        String string = this.getSchemeName();
        return string != null ? string.toUpperCase(Locale.ROOT) : super.toString();
    }
}

