/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.collect;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.EmptyImmutableListMultimap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableList;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMultimap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;

public class ImmutableListMultimap<K, V>
extends ImmutableMultimap<K, V>
implements ListMultimap<K, V> {
    public static <K, V> ImmutableListMultimap<K, V> of() {
        return EmptyImmutableListMultimap.INSTANCE;
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    static <K, V> ImmutableListMultimap<K, V> fromMapEntries(Collection<? extends Map.Entry<? extends K, ? extends Collection<? extends V>>> collection, Comparator<? super V> comparator) {
        if (collection.isEmpty()) {
            return ImmutableListMultimap.of();
        }
        ImmutableMap.Builder<K, ImmutableList<V>> builder = new ImmutableMap.Builder<K, ImmutableList<V>>(collection.size());
        int n2 = 0;
        for (Map.Entry<K, Collection<V>> entry : collection) {
            K k2 = entry.getKey();
            Collection<? extends V> collection2 = entry.getValue();
            ImmutableList<Object> immutableList = comparator == null ? ImmutableList.copyOf(collection2) : ImmutableList.sortedCopyOf(comparator, collection2);
            if (immutableList.isEmpty()) continue;
            builder.put(k2, immutableList);
            n2 += immutableList.size();
        }
        return new ImmutableListMultimap(builder.buildOrThrow(), n2);
    }

    ImmutableListMultimap(ImmutableMap<K, ImmutableList<V>> immutableMap, int n2) {
        super(immutableMap, n2);
    }

    @Override
    public ImmutableList<V> get(K k2) {
        ImmutableList immutableList = (ImmutableList)this.map.get(k2);
        return immutableList == null ? ImmutableList.of() : immutableList;
    }

    public static final class Builder<K, V>
    extends ImmutableMultimap.Builder<K, V> {
        @Override
        public Builder<K, V> put(K k2, V v2) {
            super.put(k2, v2);
            return this;
        }

        @Override
        public ImmutableListMultimap<K, V> build() {
            return (ImmutableListMultimap)super.build();
        }
    }
}

