/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.impl;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DatabindContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.type.TypeFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.util.EnumMap;
import java.util.EnumSet;

public class ClassNameIdResolver
extends TypeIdResolverBase {
    protected final PolymorphicTypeValidator _subTypeValidator;

    public ClassNameIdResolver(JavaType javaType, TypeFactory typeFactory, PolymorphicTypeValidator polymorphicTypeValidator) {
        super(javaType, typeFactory);
        this._subTypeValidator = polymorphicTypeValidator;
    }

    public static ClassNameIdResolver construct(JavaType javaType, MapperConfig<?> mapperConfig, PolymorphicTypeValidator polymorphicTypeValidator) {
        return new ClassNameIdResolver(javaType, mapperConfig.getTypeFactory(), polymorphicTypeValidator);
    }

    @Override
    public String idFromValue(Object object) {
        return this._idFrom(object, object.getClass(), this._typeFactory);
    }

    @Override
    public String idFromValueAndType(Object object, Class<?> clazz) {
        return this._idFrom(object, clazz, this._typeFactory);
    }

    @Override
    public JavaType typeFromId(DatabindContext databindContext, String string) throws IOException {
        return this._typeFromId(string, databindContext);
    }

    protected JavaType _typeFromId(String string, DatabindContext databindContext) throws IOException {
        JavaType javaType = databindContext.resolveAndValidateSubType(this._baseType, string, this._subTypeValidator);
        if (javaType == null && databindContext instanceof DeserializationContext) {
            return ((DeserializationContext)databindContext).handleUnknownTypeId(this._baseType, string, this, "no such class found");
        }
        return javaType;
    }

    protected String _idFrom(Object object, Class<?> clazz, TypeFactory typeFactory) {
        Class<?> clazz2;
        Class<?> clazz3;
        String string;
        if (ClassUtil.isEnumType(clazz) && !clazz.isEnum()) {
            clazz = clazz.getSuperclass();
        }
        if ((string = clazz.getName()).startsWith("java.util.")) {
            if (object instanceof EnumSet) {
                Class<? extends Enum<?>> clazz4 = ClassUtil.findEnumType((EnumSet)object);
                string = typeFactory.constructCollectionType(EnumSet.class, clazz4).toCanonical();
            } else if (object instanceof EnumMap) {
                Class<? extends Enum<?>> clazz5 = ClassUtil.findEnumType((EnumMap)object);
                Class<Object> clazz6 = Object.class;
                string = typeFactory.constructMapType(EnumMap.class, clazz5, clazz6).toCanonical();
            }
        } else if (string.indexOf(36) >= 0 && (clazz3 = ClassUtil.getOuterClass(clazz)) != null && ClassUtil.getOuterClass(clazz2 = this._baseType.getRawClass()) == null) {
            clazz = this._baseType.getRawClass();
            string = clazz.getName();
        }
        return string;
    }

    @Override
    public String getDescForKnownTypeIds() {
        return "class name used as type id";
    }
}

