/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.std;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.StreamReadCapability;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.type.LogicalType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JacksonStdImpl
final class UntypedObjectDeserializerNR
extends StdDeserializer<Object> {
    protected static final Object[] NO_OBJECTS = new Object[0];
    public static final UntypedObjectDeserializerNR std = new UntypedObjectDeserializerNR();
    protected final boolean _nonMerging;

    public UntypedObjectDeserializerNR() {
        this(false);
    }

    protected UntypedObjectDeserializerNR(boolean bl2) {
        super(Object.class);
        this._nonMerging = bl2;
    }

    public static UntypedObjectDeserializerNR instance(boolean bl2) {
        if (bl2) {
            return new UntypedObjectDeserializerNR(true);
        }
        return std;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Untyped;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return this._nonMerging ? Boolean.FALSE : null;
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        switch (jsonParser.currentTokenId()) {
            case 1: {
                return this._deserializeNR(jsonParser, deserializationContext, Scope.rootObjectScope(deserializationContext.isEnabled(StreamReadCapability.DUPLICATE_PROPERTIES)));
            }
            case 2: {
                return Scope.emptyMap();
            }
            case 5: {
                return this._deserializeObjectAtName(jsonParser, deserializationContext);
            }
            case 3: {
                return this._deserializeNR(jsonParser, deserializationContext, Scope.rootArrayScope());
            }
            case 6: {
                return jsonParser.getText();
            }
            case 7: {
                if (deserializationContext.hasSomeOfFeatures(F_MASK_INT_COERCIONS)) {
                    return this._coerceIntegral(jsonParser, deserializationContext);
                }
                return jsonParser.getNumberValue();
            }
            case 8: {
                if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                    return jsonParser.getDecimalValue();
                }
                return jsonParser.getNumberValue();
            }
            case 9: {
                return Boolean.TRUE;
            }
            case 10: {
                return Boolean.FALSE;
            }
            case 11: {
                return null;
            }
            case 12: {
                return jsonParser.getEmbeddedObject();
            }
        }
        return deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        switch (jsonParser.currentTokenId()) {
            case 1: 
            case 3: 
            case 5: {
                return typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
            }
        }
        return this._deserializeAnyScalar(jsonParser, deserializationContext, jsonParser.currentTokenId());
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException {
        if (this._nonMerging) {
            return this.deserialize(jsonParser, deserializationContext);
        }
        switch (jsonParser.currentTokenId()) {
            case 2: 
            case 4: {
                return object;
            }
            case 1: {
                Object object2 = jsonParser.nextToken();
                if (object2 == JsonToken.END_OBJECT) {
                    return object;
                }
            }
            case 5: {
                if (!(object instanceof Map)) break;
                Object object2 = (Map)object;
                String string = jsonParser.currentName();
                do {
                    jsonParser.nextToken();
                    Object v2 = object2.get(string);
                    Object object3 = v2 != null ? this.deserialize(jsonParser, deserializationContext, v2) : this.deserialize(jsonParser, deserializationContext);
                    if (object3 == v2) continue;
                    object2.put(string, object3);
                } while ((string = jsonParser.nextFieldName()) != null);
                return object;
            }
            case 3: {
                Object object4 = jsonParser.nextToken();
                if (object4 == JsonToken.END_ARRAY) {
                    return object;
                }
                if (!(object instanceof Collection)) break;
                object4 = (Collection)object;
                do {
                    object4.add(this.deserialize(jsonParser, deserializationContext));
                } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
                return object;
            }
        }
        return this.deserialize(jsonParser, deserializationContext);
    }

    private Object _deserializeObjectAtName(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Scope scope = Scope.rootObjectScope(deserializationContext.isEnabled(StreamReadCapability.DUPLICATE_PROPERTIES));
        String string = jsonParser.currentName();
        while (string != null) {
            Object object;
            JsonToken jsonToken = jsonParser.nextToken();
            if (jsonToken == null) {
                jsonToken = JsonToken.NOT_AVAILABLE;
            }
            switch (jsonToken.id()) {
                case 1: {
                    object = this._deserializeNR(jsonParser, deserializationContext, scope.childObject());
                    break;
                }
                case 2: {
                    return scope.finishRootObject();
                }
                case 3: {
                    object = this._deserializeNR(jsonParser, deserializationContext, scope.childArray());
                    break;
                }
                default: {
                    object = this._deserializeAnyScalar(jsonParser, deserializationContext, jsonToken.id());
                }
            }
            scope.putValue(string, object);
            string = jsonParser.nextFieldName();
        }
        return scope.finishRootObject();
    }

    private Object _deserializeNR(JsonParser jsonParser, DeserializationContext deserializationContext, Scope scope) throws IOException {
        boolean bl2 = deserializationContext.hasSomeOfFeatures(F_MASK_INT_COERCIONS);
        boolean bl3 = deserializationContext.isEnabled(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY);
        Scope scope2 = scope;
        block23: while (true) {
            Object object;
            Object object2;
            block30: {
                if (!scope2.isObject()) break block30;
                object2 = jsonParser.nextFieldName();
                while (object2 != null) {
                    block31: {
                        JsonToken jsonToken = jsonParser.nextToken();
                        if (jsonToken == null) {
                            jsonToken = JsonToken.NOT_AVAILABLE;
                        }
                        switch (jsonToken.id()) {
                            case 1: {
                                scope2 = scope2.childObject((String)object2);
                                break block31;
                            }
                            case 3: {
                                scope2 = scope2.childArray((String)object2);
                                continue block23;
                            }
                            case 6: {
                                object = jsonParser.getText();
                                break;
                            }
                            case 7: {
                                object = bl2 ? this._coerceIntegral(jsonParser, deserializationContext) : jsonParser.getNumberValue();
                                break;
                            }
                            case 8: {
                                object = deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS) ? jsonParser.getDecimalValue() : jsonParser.getNumberValue();
                                break;
                            }
                            case 9: {
                                object = Boolean.TRUE;
                                break;
                            }
                            case 10: {
                                object = Boolean.FALSE;
                                break;
                            }
                            case 11: {
                                object = null;
                                break;
                            }
                            case 12: {
                                object = jsonParser.getEmbeddedObject();
                                break;
                            }
                            default: {
                                return deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
                            }
                        }
                        scope2.putValue((String)object2, object);
                    }
                    object2 = jsonParser.nextFieldName();
                }
                if (scope2 == scope) {
                    return scope2.finishRootObject();
                }
                scope2 = scope2.finishBranchObject();
                continue;
            }
            while (true) {
                if ((object2 = jsonParser.nextToken()) == null) {
                    object2 = JsonToken.NOT_AVAILABLE;
                }
                switch (((JsonToken)((Object)object2)).id()) {
                    case 1: {
                        scope2 = scope2.childObject();
                        continue block23;
                    }
                    case 3: {
                        scope2 = scope2.childArray();
                        continue block23;
                    }
                    case 4: {
                        if (scope2 == scope) {
                            return scope2.finishRootArray(bl3);
                        }
                        scope2 = scope2.finishBranchArray(bl3);
                        continue block23;
                    }
                    case 6: {
                        object = jsonParser.getText();
                        break;
                    }
                    case 7: {
                        object = bl2 ? this._coerceIntegral(jsonParser, deserializationContext) : jsonParser.getNumberValue();
                        break;
                    }
                    case 8: {
                        object = deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS) ? jsonParser.getDecimalValue() : jsonParser.getNumberValue();
                        break;
                    }
                    case 9: {
                        object = Boolean.TRUE;
                        break;
                    }
                    case 10: {
                        object = Boolean.FALSE;
                        break;
                    }
                    case 11: {
                        object = null;
                        break;
                    }
                    case 12: {
                        object = jsonParser.getEmbeddedObject();
                        break;
                    }
                    default: {
                        return deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
                    }
                }
                scope2.addValue(object);
            }
            break;
        }
    }

    private Object _deserializeAnyScalar(JsonParser jsonParser, DeserializationContext deserializationContext, int n2) throws IOException {
        switch (n2) {
            case 6: {
                return jsonParser.getText();
            }
            case 7: {
                if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS)) {
                    return jsonParser.getBigIntegerValue();
                }
                return jsonParser.getNumberValue();
            }
            case 8: {
                if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                    return jsonParser.getDecimalValue();
                }
                return jsonParser.getNumberValue();
            }
            case 9: {
                return Boolean.TRUE;
            }
            case 10: {
                return Boolean.FALSE;
            }
            case 12: {
                return jsonParser.getEmbeddedObject();
            }
            case 11: {
                return null;
            }
        }
        return deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
    }

    private static final class Scope {
        private final Scope _parent;
        private Scope _child;
        private boolean _isObject;
        private boolean _squashDups;
        private String _deferredKey;
        private Map<String, Object> _map;
        private List<Object> _list;

        private Scope(Scope scope) {
            this._parent = scope;
            this._isObject = false;
            this._squashDups = false;
        }

        private Scope(Scope scope, boolean bl2, boolean bl3) {
            this._parent = scope;
            this._isObject = bl2;
            this._squashDups = bl3;
        }

        public static Scope rootObjectScope(boolean bl2) {
            return new Scope(null, true, bl2);
        }

        public static Scope rootArrayScope() {
            return new Scope(null);
        }

        private Scope resetAsArray() {
            this._isObject = false;
            return this;
        }

        private Scope resetAsObject(boolean bl2) {
            this._isObject = true;
            this._squashDups = bl2;
            return this;
        }

        public Scope childObject() {
            if (this._child == null) {
                return new Scope(this, true, this._squashDups);
            }
            return this._child.resetAsObject(this._squashDups);
        }

        public Scope childObject(String string) {
            this._deferredKey = string;
            if (this._child == null) {
                return new Scope(this, true, this._squashDups);
            }
            return this._child.resetAsObject(this._squashDups);
        }

        public Scope childArray() {
            if (this._child == null) {
                return new Scope(this);
            }
            return this._child.resetAsArray();
        }

        public Scope childArray(String string) {
            this._deferredKey = string;
            if (this._child == null) {
                return new Scope(this);
            }
            return this._child.resetAsArray();
        }

        public boolean isObject() {
            return this._isObject;
        }

        public void putValue(String string, Object object) {
            if (this._squashDups) {
                this._putValueHandleDups(string, object);
                return;
            }
            if (this._map == null) {
                this._map = new LinkedHashMap<String, Object>();
            }
            this._map.put(string, object);
        }

        public Scope putDeferredValue(Object object) {
            String string = Objects.requireNonNull(this._deferredKey);
            this._deferredKey = null;
            if (this._squashDups) {
                this._putValueHandleDups(string, object);
                return this;
            }
            if (this._map == null) {
                this._map = new LinkedHashMap<String, Object>();
            }
            this._map.put(string, object);
            return this;
        }

        public void addValue(Object object) {
            if (this._list == null) {
                this._list = new ArrayList<Object>();
            }
            this._list.add(object);
        }

        public Object finishRootObject() {
            if (this._map == null) {
                return Scope.emptyMap();
            }
            return this._map;
        }

        public Scope finishBranchObject() {
            Map<String, Object> map;
            if (this._map == null) {
                map = new LinkedHashMap<String, Object>();
            } else {
                map = this._map;
                this._map = null;
            }
            if (this._parent.isObject()) {
                return this._parent.putDeferredValue(map);
            }
            this._parent.addValue(map);
            return this._parent;
        }

        public Object finishRootArray(boolean bl2) {
            if (this._list == null) {
                if (bl2) {
                    return NO_OBJECTS;
                }
                return Scope.emptyList();
            }
            if (bl2) {
                return this._list.toArray(NO_OBJECTS);
            }
            return this._list;
        }

        public Scope finishBranchArray(boolean bl2) {
            Object object;
            if (this._list == null) {
                object = bl2 ? NO_OBJECTS : Scope.emptyList();
            } else {
                object = bl2 ? this._list.toArray(NO_OBJECTS) : this._list;
                this._list = null;
            }
            if (this._parent.isObject()) {
                return this._parent.putDeferredValue(object);
            }
            this._parent.addValue(object);
            return this._parent;
        }

        private void _putValueHandleDups(String string, Object object) {
            if (this._map == null) {
                this._map = new LinkedHashMap<String, Object>();
                this._map.put(string, object);
                return;
            }
            Object object2 = this._map.put(string, object);
            if (object2 != null) {
                if (object2 instanceof List) {
                    ((List)object2).add(object);
                    this._map.put(string, object2);
                } else {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    arrayList.add(object2);
                    arrayList.add(object);
                    this._map.put(string, arrayList);
                }
            }
        }

        public static Map<String, Object> emptyMap() {
            return new LinkedHashMap<String, Object>(2);
        }

        public static List<Object> emptyList() {
            return new ArrayList<Object>(2);
        }
    }
}

