/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonInclude;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.PropertyMetadata;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.PropertyName;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializerProvider;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.type.TypeFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.Named;
import java.io.Serializable;

public interface BeanProperty
extends Named {
    public static final JsonFormat.Value EMPTY_FORMAT = new JsonFormat.Value();
    public static final JsonInclude.Value EMPTY_INCLUDE = JsonInclude.Value.empty();

    @Override
    public String getName();

    public PropertyName getFullName();

    public JavaType getType();

    public PropertyMetadata getMetadata();

    public AnnotatedMember getMember();

    public JsonFormat.Value findPropertyFormat(MapperConfig<?> var1, Class<?> var2);

    public JsonInclude.Value findPropertyInclusion(MapperConfig<?> var1, Class<?> var2);

    public void depositSchemaProperty(JsonObjectFormatVisitor var1, SerializerProvider var2) throws JsonMappingException;

    public static class Bogus
    implements BeanProperty {
        @Override
        public String getName() {
            return "";
        }

        @Override
        public PropertyName getFullName() {
            return PropertyName.NO_NAME;
        }

        @Override
        public JavaType getType() {
            return TypeFactory.unknownType();
        }

        @Override
        public PropertyMetadata getMetadata() {
            return PropertyMetadata.STD_REQUIRED_OR_OPTIONAL;
        }

        @Override
        public AnnotatedMember getMember() {
            return null;
        }

        @Override
        public JsonFormat.Value findPropertyFormat(MapperConfig<?> mapperConfig, Class<?> clazz) {
            return JsonFormat.Value.empty();
        }

        @Override
        public JsonInclude.Value findPropertyInclusion(MapperConfig<?> mapperConfig, Class<?> clazz) {
            return null;
        }

        @Override
        public void depositSchemaProperty(JsonObjectFormatVisitor jsonObjectFormatVisitor, SerializerProvider serializerProvider) throws JsonMappingException {
        }
    }

    public static class Std
    implements BeanProperty,
    Serializable {
        protected final PropertyName _name;
        protected final JavaType _type;
        protected final PropertyName _wrapperName;
        protected final PropertyMetadata _metadata;
        protected final AnnotatedMember _member;

        public Std(PropertyName propertyName, JavaType javaType, PropertyName propertyName2, AnnotatedMember annotatedMember, PropertyMetadata propertyMetadata) {
            this._name = propertyName;
            this._type = javaType;
            this._wrapperName = propertyName2;
            this._metadata = propertyMetadata;
            this._member = annotatedMember;
        }

        @Override
        public JsonFormat.Value findPropertyFormat(MapperConfig<?> mapperConfig, Class<?> clazz) {
            JsonFormat.Value value = mapperConfig.getDefaultPropertyFormat(clazz);
            AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
            if (annotationIntrospector == null || this._member == null) {
                return value;
            }
            JsonFormat.Value value2 = annotationIntrospector.findFormat(this._member);
            if (value2 == null) {
                return value;
            }
            return value.withOverrides(value2);
        }

        @Override
        public JsonInclude.Value findPropertyInclusion(MapperConfig<?> mapperConfig, Class<?> clazz) {
            JsonInclude.Value value = mapperConfig.getDefaultInclusion(clazz, this._type.getRawClass());
            AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
            if (annotationIntrospector == null || this._member == null) {
                return value;
            }
            JsonInclude.Value value2 = annotationIntrospector.findPropertyInclusion(this._member);
            if (value2 == null) {
                return value;
            }
            return value.withOverrides(value2);
        }

        @Override
        public String getName() {
            return this._name.getSimpleName();
        }

        @Override
        public PropertyName getFullName() {
            return this._name;
        }

        @Override
        public JavaType getType() {
            return this._type;
        }

        public PropertyName getWrapperName() {
            return this._wrapperName;
        }

        @Override
        public PropertyMetadata getMetadata() {
            return this._metadata;
        }

        @Override
        public AnnotatedMember getMember() {
            return this._member;
        }

        @Override
        public void depositSchemaProperty(JsonObjectFormatVisitor jsonObjectFormatVisitor, SerializerProvider serializerProvider) {
            throw new UnsupportedOperationException("Instances of " + this.getClass().getName() + " should not get visited");
        }
    }
}

