/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.writer.relaxng;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.AnyNameClass;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ChoiceNameClass;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.DifferenceNameClass;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.NameClass;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.NameClassVisitor;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.NamespaceNameClass;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.NotNameClass;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.SimpleNameClass;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.writer.XMLWriter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.writer.relaxng.Context;
import java.util.Stack;

public class NameClassWriter
implements NameClassVisitor {
    private final XMLWriter writer;
    private final String defaultNs;

    public NameClassWriter(Context context) {
        this.writer = context.getWriter();
        this.defaultNs = context.getTargetNamespace();
    }

    public Object onAnyName(AnyNameClass anyNameClass) {
        this.writer.element("anyName");
        return null;
    }

    protected void startWithNs(String string, String string2) {
        if (string2.equals(this.defaultNs)) {
            this.writer.start(string);
        } else {
            this.writer.start(string, new String[]{"ns", string2});
        }
    }

    public Object onSimple(SimpleNameClass simpleNameClass) {
        this.startWithNs("name", simpleNameClass.namespaceURI);
        this.writer.characters(simpleNameClass.localName);
        this.writer.end("name");
        return null;
    }

    public Object onNsName(NamespaceNameClass namespaceNameClass) {
        this.startWithNs("nsName", namespaceNameClass.namespaceURI);
        this.writer.end("nsName");
        return null;
    }

    public Object onNot(NotNameClass notNameClass) {
        throw new Error();
    }

    public Object onChoice(ChoiceNameClass choiceNameClass) {
        this.writer.start("choice");
        this.processChoice(choiceNameClass);
        this.writer.end("choice");
        return null;
    }

    private void processChoice(ChoiceNameClass choiceNameClass) {
        Stack<NameClass> stack = new Stack<NameClass>();
        stack.push(choiceNameClass.nc1);
        stack.push(choiceNameClass.nc2);
        while (!stack.empty()) {
            NameClass nameClass = (NameClass)stack.pop();
            if (nameClass instanceof ChoiceNameClass) {
                stack.push(((ChoiceNameClass)nameClass).nc1);
                stack.push(((ChoiceNameClass)nameClass).nc2);
                continue;
            }
            nameClass.visit(this);
        }
    }

    public Object onDifference(DifferenceNameClass differenceNameClass) {
        if (differenceNameClass.nc1 instanceof AnyNameClass) {
            this.writer.start("anyName");
            this.writer.start("except");
            if (differenceNameClass.nc2 instanceof ChoiceNameClass) {
                this.processChoice((ChoiceNameClass)differenceNameClass.nc2);
            } else {
                differenceNameClass.nc2.visit(this);
            }
            this.writer.end("except");
            this.writer.end("anyName");
        } else if (differenceNameClass.nc1 instanceof NamespaceNameClass) {
            this.startWithNs("nsName", ((NamespaceNameClass)differenceNameClass.nc1).namespaceURI);
            this.writer.start("except");
            if (differenceNameClass.nc2 instanceof ChoiceNameClass) {
                this.processChoice((ChoiceNameClass)differenceNameClass.nc2);
            } else {
                differenceNameClass.nc2.visit(this);
            }
            this.writer.end("except");
            this.writer.end("nsName");
        } else {
            throw new Error();
        }
        return null;
    }
}

