/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.io;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.WriterConfig;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.CompletelyCloseable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public final class UTF8Writer
extends Writer
implements CompletelyCloseable {
    private static final int DEFAULT_BUF_LEN = 4000;
    static final int SURR1_FIRST = 55296;
    static final int SURR1_LAST = 56319;
    static final int SURR2_FIRST = 56320;
    static final int SURR2_LAST = 57343;
    final WriterConfig mConfig;
    final boolean mAutoCloseOutput;
    final OutputStream mOut;
    byte[] mOutBuffer;
    final int mOutBufferLast;
    int mOutPtr;
    int mSurrogate = 0;

    public UTF8Writer(WriterConfig writerConfig, OutputStream outputStream, boolean bl2) {
        this.mConfig = writerConfig;
        this.mAutoCloseOutput = bl2;
        this.mOut = outputStream;
        this.mOutBuffer = this.mConfig == null ? new byte[4000] : writerConfig.allocFullBBuffer(4000);
        this.mOutBufferLast = this.mOutBuffer.length - 4;
        this.mOutPtr = 0;
    }

    @Override
    public void closeCompletely() throws IOException {
        this._close(true);
    }

    @Override
    public void close() throws IOException {
        this._close(this.mAutoCloseOutput);
    }

    @Override
    public void flush() throws IOException {
        if (this.mOutPtr > 0 && this.mOutBuffer != null) {
            this.mOut.write(this.mOutBuffer, 0, this.mOutPtr);
            this.mOutPtr = 0;
        }
        this.mOut.flush();
    }

    @Override
    public void write(char[] cArray) throws IOException {
        this.write(cArray, 0, cArray.length);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void write(char[] var1_1, int var2_2, int var3_3) throws IOException {
        if (var3_3 < 2) {
            if (var3_3 == 1) {
                this.write(var1_1[var2_2]);
            }
            return;
        }
        if (this.mSurrogate > 0) {
            var4_4 = var1_1[var2_2++];
            --var3_3;
            this.write(this._convertSurrogate(var4_4));
        }
        var4_4 = this.mOutPtr;
        var5_5 = this.mOutBuffer;
        var6_6 = this.mOutBufferLast;
        var3_3 += var2_2;
        block0: while (var2_2 < var3_3) {
            if (var4_4 >= var6_6) {
                this.mOut.write(var5_5, 0, var4_4);
                var4_4 = 0;
            }
            if ((var7_7 = var1_1[var2_2++]) >= 128) ** GOTO lbl28
            var5_5[var4_4++] = (byte)var7_7;
            var8_8 = var3_3 - var2_2;
            var9_9 = var6_6 - var4_4;
            if (var8_8 > var9_9) {
                var8_8 = var9_9;
            }
            var8_8 += var2_2;
            while (var2_2 < var8_8) {
                if ((var7_7 = var1_1[var2_2++]) < 128) {
                    var5_5[var4_4++] = (byte)var7_7;
                    continue;
                }
lbl28:
                // 3 sources

                if (var7_7 < 2048) {
                    var5_5[var4_4++] = (byte)(192 | var7_7 >> 6);
                    var5_5[var4_4++] = (byte)(128 | var7_7 & 63);
                    continue block0;
                }
                if (var7_7 < 55296 || var7_7 > 57343) {
                    var5_5[var4_4++] = (byte)(224 | var7_7 >> 12);
                    var5_5[var4_4++] = (byte)(128 | var7_7 >> 6 & 63);
                    var5_5[var4_4++] = (byte)(128 | var7_7 & 63);
                    continue block0;
                }
                if (var7_7 > 56319) {
                    this.mOutPtr = var4_4;
                    this.throwIllegal(var7_7);
                }
                this.mSurrogate = var7_7;
                if (var2_2 >= var3_3) break block0;
                if ((var7_7 = this._convertSurrogate(var1_1[var2_2++])) > 0x10FFFF) {
                    this.mOutPtr = var4_4;
                    this.throwIllegal(var7_7);
                }
                var5_5[var4_4++] = (byte)(240 | var7_7 >> 18);
                var5_5[var4_4++] = (byte)(128 | var7_7 >> 12 & 63);
                var5_5[var4_4++] = (byte)(128 | var7_7 >> 6 & 63);
                var5_5[var4_4++] = (byte)(128 | var7_7 & 63);
                continue block0;
            }
        }
        this.mOutPtr = var4_4;
    }

    @Override
    public void write(int n2) throws IOException {
        if (this.mSurrogate > 0) {
            n2 = this._convertSurrogate(n2);
        } else if (n2 >= 55296 && n2 <= 57343) {
            if (n2 > 56319) {
                this.throwIllegal(n2);
            }
            this.mSurrogate = n2;
            return;
        }
        if (this.mOutPtr >= this.mOutBufferLast) {
            this.mOut.write(this.mOutBuffer, 0, this.mOutPtr);
            this.mOutPtr = 0;
        }
        if (n2 < 128) {
            this.mOutBuffer[this.mOutPtr++] = (byte)n2;
        } else {
            int n3 = this.mOutPtr;
            if (n2 < 2048) {
                this.mOutBuffer[n3++] = (byte)(0xC0 | n2 >> 6);
                this.mOutBuffer[n3++] = (byte)(0x80 | n2 & 0x3F);
            } else if (n2 <= 65535) {
                this.mOutBuffer[n3++] = (byte)(0xE0 | n2 >> 12);
                this.mOutBuffer[n3++] = (byte)(0x80 | n2 >> 6 & 0x3F);
                this.mOutBuffer[n3++] = (byte)(0x80 | n2 & 0x3F);
            } else {
                if (n2 > 0x10FFFF) {
                    this.throwIllegal(n2);
                }
                this.mOutBuffer[n3++] = (byte)(0xF0 | n2 >> 18);
                this.mOutBuffer[n3++] = (byte)(0x80 | n2 >> 12 & 0x3F);
                this.mOutBuffer[n3++] = (byte)(0x80 | n2 >> 6 & 0x3F);
                this.mOutBuffer[n3++] = (byte)(0x80 | n2 & 0x3F);
            }
            this.mOutPtr = n3;
        }
    }

    @Override
    public void write(String string) throws IOException {
        this.write(string, 0, string.length());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void write(String var1_1, int var2_2, int var3_3) throws IOException {
        if (var3_3 < 2) {
            if (var3_3 == 1) {
                this.write(var1_1.charAt(var2_2));
            }
            return;
        }
        if (this.mSurrogate > 0) {
            var4_4 = var1_1.charAt(var2_2++);
            --var3_3;
            this.write(this._convertSurrogate(var4_4));
        }
        var4_4 = this.mOutPtr;
        var5_5 = this.mOutBuffer;
        var6_6 = this.mOutBufferLast;
        var3_3 += var2_2;
        block0: while (var2_2 < var3_3) {
            if (var4_4 >= var6_6) {
                this.mOut.write(var5_5, 0, var4_4);
                var4_4 = 0;
            }
            if ((var7_7 = var1_1.charAt(var2_2++)) >= 128) ** GOTO lbl28
            var5_5[var4_4++] = (byte)var7_7;
            var8_8 = var3_3 - var2_2;
            var9_9 = var6_6 - var4_4;
            if (var8_8 > var9_9) {
                var8_8 = var9_9;
            }
            var8_8 += var2_2;
            while (var2_2 < var8_8) {
                if ((var7_7 = (int)var1_1.charAt(var2_2++)) < 128) {
                    var5_5[var4_4++] = (byte)var7_7;
                    continue;
                }
lbl28:
                // 3 sources

                if (var7_7 < 2048) {
                    var5_5[var4_4++] = (byte)(192 | var7_7 >> 6);
                    var5_5[var4_4++] = (byte)(128 | var7_7 & 63);
                    continue block0;
                }
                if (var7_7 < 55296 || var7_7 > 57343) {
                    var5_5[var4_4++] = (byte)(224 | var7_7 >> 12);
                    var5_5[var4_4++] = (byte)(128 | var7_7 >> 6 & 63);
                    var5_5[var4_4++] = (byte)(128 | var7_7 & 63);
                    continue block0;
                }
                if (var7_7 > 56319) {
                    this.mOutPtr = var4_4;
                    this.throwIllegal(var7_7);
                }
                this.mSurrogate = var7_7;
                if (var2_2 >= var3_3) break block0;
                if ((var7_7 = this._convertSurrogate(var1_1.charAt(var2_2++))) > 0x10FFFF) {
                    this.mOutPtr = var4_4;
                    this.throwIllegal(var7_7);
                }
                var5_5[var4_4++] = (byte)(240 | var7_7 >> 18);
                var5_5[var4_4++] = (byte)(128 | var7_7 >> 12 & 63);
                var5_5[var4_4++] = (byte)(128 | var7_7 >> 6 & 63);
                var5_5[var4_4++] = (byte)(128 | var7_7 & 63);
                continue block0;
            }
        }
        this.mOutPtr = var4_4;
    }

    private final void _close(boolean bl2) throws IOException {
        int n2;
        byte[] byArray = this.mOutBuffer;
        if (byArray != null) {
            this.mOutBuffer = null;
            if (this.mOutPtr > 0) {
                this.mOut.write(byArray, 0, this.mOutPtr);
                this.mOutPtr = 0;
            }
            if (this.mConfig != null) {
                this.mConfig.freeFullBBuffer(byArray);
            }
        }
        if (bl2) {
            this.mOut.close();
        }
        if ((n2 = this.mSurrogate) > 0) {
            this.mSurrogate = 0;
            this.throwIllegal(n2);
        }
    }

    private final int _convertSurrogate(int n2) throws IOException {
        int n3 = this.mSurrogate;
        this.mSurrogate = 0;
        if (n2 < 56320 || n2 > 57343) {
            throw new IOException("Broken surrogate pair: first char 0x" + Integer.toHexString(n3) + ", second 0x" + Integer.toHexString(n2) + "; illegal combination");
        }
        return 65536 + (n3 - 55296 << 10) + (n2 - 56320);
    }

    private void throwIllegal(int n2) throws IOException {
        if (n2 > 0x10FFFF) {
            throw new IOException("Illegal character point (0x" + Integer.toHexString(n2) + ") to output; max is 0x10FFFF as per RFC 3629");
        }
        if (n2 >= 55296) {
            if (n2 <= 56319) {
                throw new IOException("Unmatched first part of surrogate pair (0x" + Integer.toHexString(n2) + ")");
            }
            throw new IOException("Unmatched second part of surrogate pair (0x" + Integer.toHexString(n2) + ")");
        }
        throw new IOException("Illegal character point (0x" + Integer.toHexString(n2) + ") to output");
    }
}

