/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.ConcatModel;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.ContentSpec;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.ModelNode;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.TokenModel;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.PrefixedName;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public final class DFAState {
    final int mIndex;
    final boolean mAccepting;
    BitSet mTokenSet;
    HashMap<PrefixedName, DFAState> mNext = new HashMap();

    public DFAState(int n2, BitSet bitSet) {
        this.mIndex = n2;
        this.mAccepting = bitSet.get(0);
        this.mTokenSet = bitSet;
    }

    public static DFAState constructDFA(ContentSpec contentSpec) {
        ModelNode modelNode = contentSpec.rewrite();
        TokenModel tokenModel = TokenModel.getNullToken();
        ConcatModel concatModel = new ConcatModel(modelNode, tokenModel);
        ArrayList<TokenModel> arrayList = new ArrayList<TokenModel>();
        arrayList.add(tokenModel);
        concatModel.indexTokens(arrayList);
        int n2 = arrayList.size();
        BitSet[] bitSetArray = new BitSet[n2];
        PrefixedName[] prefixedNameArray = new PrefixedName[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            bitSetArray[i2] = new BitSet(n2);
            prefixedNameArray[i2] = arrayList.get(i2).getName();
        }
        concatModel.calcFollowPos(bitSetArray);
        BitSet bitSet = new BitSet(n2);
        concatModel.addFirstPos(bitSet);
        DFAState dFAState = new DFAState(0, bitSet);
        ArrayList<DFAState> arrayList2 = new ArrayList<DFAState>();
        arrayList2.add(dFAState);
        HashMap<BitSet, DFAState> hashMap = new HashMap<BitSet, DFAState>();
        hashMap.put(bitSet, dFAState);
        int n3 = 0;
        while (n3 < arrayList2.size()) {
            DFAState dFAState2 = (DFAState)arrayList2.get(n3++);
            dFAState2.calcNext(prefixedNameArray, bitSetArray, arrayList2, hashMap);
        }
        return dFAState;
    }

    public boolean isAcceptingState() {
        return this.mAccepting;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public DFAState findNext(PrefixedName prefixedName) {
        return this.mNext.get(prefixedName);
    }

    public TreeSet<PrefixedName> getNextNames() {
        TreeSet<PrefixedName> treeSet = new TreeSet<PrefixedName>();
        for (PrefixedName prefixedName : this.mNext.keySet()) {
            treeSet.add(prefixedName);
        }
        return treeSet;
    }

    public void calcNext(PrefixedName[] prefixedNameArray, BitSet[] bitSetArray, List<DFAState> list, Map<BitSet, DFAState> map) {
        int n2 = -1;
        BitSet bitSet = (BitSet)this.mTokenSet.clone();
        this.mTokenSet = null;
        while ((n2 = bitSet.nextSetBit(n2 + 1)) >= 0) {
            PrefixedName prefixedName = prefixedNameArray[n2];
            if (prefixedName == null) continue;
            BitSet bitSet2 = (BitSet)bitSetArray[n2].clone();
            int n3 = n2;
            while ((n3 = bitSet.nextSetBit(n3 + 1)) > 0) {
                if (prefixedNameArray[n3] != prefixedName) continue;
                bitSet.clear(n3);
                bitSet2.or(bitSetArray[n3]);
            }
            DFAState dFAState = map.get(bitSet2);
            if (dFAState == null) {
                dFAState = new DFAState(list.size(), bitSet2);
                list.add(dFAState);
                map.put(bitSet2, dFAState);
            }
            this.mNext.put(prefixedName, dFAState);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("State #" + this.mIndex + ":\n");
        stringBuilder.append("  Accepting: " + this.mAccepting);
        stringBuilder.append("\n  Next states:\n");
        for (Map.Entry<PrefixedName, DFAState> entry : this.mNext.entrySet()) {
            stringBuilder.append(entry.getKey());
            stringBuilder.append(" -> ");
            DFAState dFAState = entry.getValue();
            stringBuilder.append(dFAState.getIndex());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

