/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.dom;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw.OutputElementBase;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.BijectiveNsMap;
import javax.xml.namespace.NamespaceContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMOutputElement
extends OutputElementBase {
    private DOMOutputElement mParent;
    private final Node mRootNode;
    private Element mElement;
    private boolean mDefaultNsSet;

    private DOMOutputElement(Node node) {
        this.mRootNode = node;
        this.mParent = null;
        this.mElement = null;
        this.mNsMapping = null;
        this.mNsMapShared = false;
        this.mDefaultNsURI = "";
        this.mRootNsContext = null;
        this.mDefaultNsSet = false;
    }

    private DOMOutputElement(DOMOutputElement dOMOutputElement, Element element, BijectiveNsMap bijectiveNsMap) {
        super(dOMOutputElement, bijectiveNsMap);
        this.mRootNode = null;
        this.mParent = dOMOutputElement;
        this.mElement = element;
        this.mNsMapping = bijectiveNsMap;
        this.mNsMapShared = bijectiveNsMap != null;
        this.mDefaultNsURI = dOMOutputElement.mDefaultNsURI;
        this.mRootNsContext = dOMOutputElement.mRootNsContext;
        this.mDefaultNsSet = false;
    }

    private void relink(DOMOutputElement dOMOutputElement, Element element) {
        super.relink(dOMOutputElement);
        this.mParent = dOMOutputElement;
        this.mElement = element;
        dOMOutputElement.appendNode(element);
        this.mDefaultNsSet = false;
    }

    public static DOMOutputElement createRoot(Node node) {
        return new DOMOutputElement(node);
    }

    protected DOMOutputElement createAndAttachChild(Element element) {
        if (this.mRootNode != null) {
            this.mRootNode.appendChild(element);
        } else {
            this.mElement.appendChild(element);
        }
        return this.createChild(element);
    }

    protected DOMOutputElement createChild(Element element) {
        return new DOMOutputElement(this, element, this.mNsMapping);
    }

    protected DOMOutputElement reuseAsChild(DOMOutputElement dOMOutputElement, Element element) {
        DOMOutputElement dOMOutputElement2 = this.mParent;
        this.relink(dOMOutputElement, element);
        return dOMOutputElement2;
    }

    protected void addToPool(DOMOutputElement dOMOutputElement) {
        this.mParent = dOMOutputElement;
    }

    public DOMOutputElement getParent() {
        return this.mParent;
    }

    @Override
    public boolean isRoot() {
        return this.mParent == null;
    }

    @Override
    public String getNameDesc() {
        if (this.mElement != null) {
            return this.mElement.getLocalName();
        }
        return "#error";
    }

    @Override
    public void setDefaultNsUri(String string) {
        this.mDefaultNsURI = string;
        this.mDefaultNsSet = true;
    }

    @Override
    protected void setRootNsContext(NamespaceContext namespaceContext) {
        String string;
        this.mRootNsContext = namespaceContext;
        if (!this.mDefaultNsSet && (string = namespaceContext.getNamespaceURI("")) != null && string.length() > 0) {
            this.mDefaultNsURI = string;
        }
    }

    protected void appendNode(Node node) {
        if (this.mRootNode != null) {
            this.mRootNode.appendChild(node);
        } else {
            this.mElement.appendChild(node);
        }
    }

    protected void addAttribute(String string, String string2) {
        this.mElement.setAttribute(string, string2);
    }

    protected void addAttribute(String string, String string2, String string3) {
        this.mElement.setAttributeNS(string, string2, string3);
    }

    public void appendChild(Node node) {
        this.mElement.appendChild(node);
    }
}

