/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.tools.api.impl;

import com.gradle.maven.extension.internal.dep.org.objectweb.asm.AnnotationVisitor;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.ClassVisitor;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.FieldVisitor;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.ModuleVisitor;
import java.util.SortedSet;
import java.util.TreeSet;
import org.gradle.internal.tools.api.ApiMemberWriter;
import org.gradle.internal.tools.api.impl.AnnotationAnnotationValue;
import org.gradle.internal.tools.api.impl.AnnotationMember;
import org.gradle.internal.tools.api.impl.AnnotationValue;
import org.gradle.internal.tools.api.impl.ArrayAnnotationValue;
import org.gradle.internal.tools.api.impl.ClassMember;
import org.gradle.internal.tools.api.impl.EnumAnnotationValue;
import org.gradle.internal.tools.api.impl.FieldMember;
import org.gradle.internal.tools.api.impl.InnerClassMember;
import org.gradle.internal.tools.api.impl.MethodMember;
import org.gradle.internal.tools.api.impl.ParameterAnnotationMember;
import org.gradle.internal.tools.api.impl.SimpleAnnotationValue;
import org.gradle.internal.tools.api.impl.SortingAnnotationVisitor;

public class ApiMemberSelector
extends ClassVisitor {
    private final SortedSet<MethodMember> methods = new TreeSet<MethodMember>();
    private final SortedSet<FieldMember> fields = new TreeSet<FieldMember>();
    private final SortedSet<InnerClassMember> innerClasses = new TreeSet<InnerClassMember>();
    private final String className;
    private final ApiMemberWriter apiMemberWriter;
    private final boolean apiIncludesPackagePrivateMembers;
    private boolean isInnerClass;
    private ClassMember classMember;
    private boolean thisClassIsPrivateInnerClass;

    public ApiMemberSelector(String string, ApiMemberWriter apiMemberWriter, boolean bl2) {
        super(589824);
        this.className = string;
        this.apiMemberWriter = apiMemberWriter;
        this.apiIncludesPackagePrivateMembers = bl2;
    }

    public boolean isPrivateInnerClass() {
        return this.thisClassIsPrivateInnerClass;
    }

    @Override
    public void visit(int n2, int n3, String string, String string2, String string3, String[] stringArray) {
        super.visit(n2, n3, string, string2, string3, stringArray);
        this.classMember = new ClassMember(n2, n3, string, string2, string3, stringArray);
        this.isInnerClass = (n3 & 0x20) == 32;
    }

    @Override
    public ModuleVisitor visitModule(String string, int n2, String string2) {
        return this.apiMemberWriter.writeModule(string, n2, string2);
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        this.apiMemberWriter.writeClass(this.classMember, this.methods, this.fields, this.innerClasses);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, boolean bl2) {
        AnnotationMember annotationMember = new AnnotationMember(string, bl2);
        this.classMember.addAnnotation(annotationMember);
        return new SortingAnnotationVisitor(annotationMember, super.visitAnnotation(string, bl2));
    }

    @Override
    public MethodVisitor visitMethod(int n2, String string, String string2, String string3, String[] stringArray) {
        if ("<clinit>".equals(string)) {
            return null;
        }
        if (ApiMemberSelector.isCandidateApiMember(n2, this.apiIncludesPackagePrivateMembers) || "<init>".equals(string) && this.isInnerClass) {
            final MethodMember methodMember = new MethodMember(n2, string, string2, string3, stringArray);
            this.methods.add(methodMember);
            return new MethodVisitor(589824){

                @Override
                public AnnotationVisitor visitAnnotation(String string, boolean bl2) {
                    AnnotationMember annotationMember = new AnnotationMember(string, bl2);
                    methodMember.addAnnotation(annotationMember);
                    return new SortingAnnotationVisitor(annotationMember, super.visitAnnotation(string, bl2));
                }

                @Override
                public AnnotationVisitor visitAnnotationDefault() {
                    return new AnnotationDefaultVisitor(methodMember);
                }

                @Override
                public AnnotationVisitor visitParameterAnnotation(int n2, String string, boolean bl2) {
                    ParameterAnnotationMember parameterAnnotationMember = new ParameterAnnotationMember(string, bl2, n2);
                    methodMember.addParameterAnnotation(parameterAnnotationMember);
                    return new SortingAnnotationVisitor(parameterAnnotationMember, super.visitParameterAnnotation(n2, string, bl2));
                }
            };
        }
        return null;
    }

    @Override
    public FieldVisitor visitField(int n2, String string, String string2, String string3, Object object) {
        if (ApiMemberSelector.isCandidateApiMember(n2, this.apiIncludesPackagePrivateMembers)) {
            Object object2 = (n2 & 8) == 8 && (n2 & 0x10) == 16 ? object : null;
            final FieldMember fieldMember = new FieldMember(n2, string, string3, string2, object2);
            this.fields.add(fieldMember);
            return new FieldVisitor(589824){

                @Override
                public AnnotationVisitor visitAnnotation(String string, boolean bl2) {
                    AnnotationMember annotationMember = new AnnotationMember(string, bl2);
                    fieldMember.addAnnotation(annotationMember);
                    return new SortingAnnotationVisitor(annotationMember, super.visitAnnotation(string, bl2));
                }
            };
        }
        return null;
    }

    @Override
    public void visitInnerClass(String string, String string2, String string3, int n2) {
        boolean bl2;
        boolean bl3 = bl2 = (n2 & 2) != 0;
        if (string.equals(this.className) && bl2) {
            this.thisClassIsPrivateInnerClass = true;
        }
        if (string2 == null || string3 == null || bl2) {
            return;
        }
        if (!this.apiIncludesPackagePrivateMembers && ApiMemberSelector.isPackagePrivateMember(n2)) {
            return;
        }
        this.innerClasses.add(new InnerClassMember(n2, string, string2, string3));
        super.visitInnerClass(string, string2, string3, n2);
    }

    @Override
    public void visitPermittedSubclass(String string) {
        this.classMember.getPermittedSubclasses().add(string);
        super.visitPermittedSubclass(string);
    }

    public static boolean isCandidateApiMember(int n2, boolean bl2) {
        return ApiMemberSelector.isPublicMember(n2) || ApiMemberSelector.isProtectedMember(n2) || bl2 && ApiMemberSelector.isPackagePrivateMember(n2);
    }

    private static boolean isPublicMember(int n2) {
        return (n2 & 1) == 1;
    }

    private static boolean isProtectedMember(int n2) {
        return (n2 & 4) == 4;
    }

    private static boolean isPackagePrivateMember(int n2) {
        return (n2 & 7) == 0;
    }

    private static String nameOrValue(String string) {
        return string == null ? "value" : string;
    }

    private static class AnnotationDefaultVisitor
    extends AnnotationVisitor {
        private final MethodMember methodMember;

        public AnnotationDefaultVisitor(MethodMember methodMember) {
            super(589824);
            this.methodMember = methodMember;
        }

        @Override
        public void visit(String string, Object object) {
            super.visit(string, object);
            this.methodMember.setAnnotationDefaultValue(new SimpleAnnotationValue(ApiMemberSelector.nameOrValue(string), object));
        }

        @Override
        public void visitEnum(String string, String string2, String string3) {
            super.visitEnum(string, string2, string3);
            this.methodMember.setAnnotationDefaultValue(new EnumAnnotationValue(ApiMemberSelector.nameOrValue(string), string3, string2));
        }

        @Override
        public AnnotationVisitor visitAnnotation(String string, String string2) {
            AnnotationMember annotationMember = new AnnotationMember(string2, true);
            this.methodMember.setAnnotationDefaultValue(new AnnotationAnnotationValue(ApiMemberSelector.nameOrValue(string), annotationMember));
            return new SortingAnnotationVisitor(annotationMember, super.visitAnnotation(string, string2));
        }

        @Override
        public AnnotationVisitor visitArray(String string) {
            this.methodMember.setAnnotationDefaultValue(new ArrayAnnotationValue(ApiMemberSelector.nameOrValue(string), new AnnotationValue[0]));
            return super.visitArray(string);
        }
    }
}

