/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.time;

import java.util.concurrent.TimeUnit;
import org.gradle.internal.time.TimeFormatting;
import org.gradle.internal.time.TimeSource;
import org.gradle.internal.time.Timer;

class DefaultTimer
implements Timer {
    private final TimeSource timeSource;
    private long startTime;

    DefaultTimer(TimeSource timeSource) {
        this.timeSource = timeSource;
        this.reset();
    }

    @Override
    public String getElapsed() {
        long l2 = this.getElapsedMillis();
        return TimeFormatting.formatDurationVerbose(l2);
    }

    @Override
    public long getElapsedMillis() {
        long l2 = this.timeSource.nanoTime() - this.startTime;
        long l3 = TimeUnit.NANOSECONDS.toMillis(l2);
        return Math.max(l3, 0L);
    }

    public void reset() {
        this.startTime = this.timeSource.nanoTime();
    }
}

