/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.time;

import java.util.concurrent.TimeUnit;
import org.gradle.internal.time.CountdownTimer;
import org.gradle.internal.time.DefaultTimer;
import org.gradle.internal.time.TimeSource;

class DefaultCountdownTimer
extends DefaultTimer
implements CountdownTimer {
    private final long timeoutMillis;

    DefaultCountdownTimer(TimeSource timeSource, long l2, TimeUnit timeUnit) {
        super(timeSource);
        if (l2 <= 0L) {
            throw new IllegalArgumentException();
        }
        this.timeoutMillis = timeUnit.toMillis(l2);
    }

    @Override
    public boolean hasExpired() {
        return this.getRemainingMillis() <= 0L;
    }

    public long getRemainingMillis() {
        return Math.max(this.timeoutMillis - this.getElapsedMillis(), 0L);
    }
}

