/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class ThreadFactoryImpl
implements ThreadFactory {
    private final AtomicLong counter = new AtomicLong();
    private final String displayName;
    private final ClassLoader contextClassloader;

    public ThreadFactoryImpl(String string, ClassLoader classLoader) {
        this.displayName = string;
        this.contextClassloader = classLoader;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setName(this.nextThreadName());
        thread.setContextClassLoader(this.contextClassloader);
        return thread;
    }

    private String nextThreadName() {
        long l2 = this.counter.incrementAndGet();
        return l2 == 1L ? this.displayName : this.displayName + " Thread " + l2;
    }
}

