/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.gradle.cache.CacheOpenException;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.internal.AbstractCrossProcessCacheAccess;
import org.gradle.cache.internal.CacheInitializationAction;
import org.gradle.internal.UncheckedException;

public class FixedSharedModeCrossProcessCacheAccess
extends AbstractCrossProcessCacheAccess {
    private final String cacheDisplayName;
    private final File lockTarget;
    private final LockOptions lockOptions;
    private final FileLockManager lockManager;
    private final CacheInitializationAction initializationAction;
    private final Consumer<FileLock> onOpenAction;
    private final Consumer<FileLock> onCloseAction;
    private FileLock fileLock;

    public FixedSharedModeCrossProcessCacheAccess(String string, File file, LockOptions lockOptions, FileLockManager fileLockManager, CacheInitializationAction cacheInitializationAction, Consumer<FileLock> consumer, Consumer<FileLock> consumer2) {
        assert (lockOptions.getMode() == FileLockManager.LockMode.Shared);
        this.cacheDisplayName = string;
        this.lockTarget = file;
        this.lockOptions = lockOptions;
        this.lockManager = fileLockManager;
        this.initializationAction = cacheInitializationAction;
        this.onOpenAction = consumer;
        this.onCloseAction = consumer2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        if (this.fileLock != null) {
            throw new IllegalStateException("File lock " + this.lockTarget + " is already open.");
        }
        FileLock fileLock = this.lockManager.lock(this.lockTarget, this.lockOptions, this.cacheDisplayName);
        try {
            boolean bl2 = this.initializationAction.requiresInitialization(fileLock);
            if (bl2) {
                Exception exception = null;
                for (int i2 = 0; bl2 && i2 < 3; ++i2) {
                    fileLock.close();
                    fileLock = null;
                    FileLock fileLock2 = null;
                    try {
                        fileLock2 = this.lockManager.lock(this.lockTarget, this.lockOptions.copyWithMode(FileLockManager.LockMode.Exclusive), this.cacheDisplayName);
                    }
                    catch (Exception exception2) {
                        exception = exception2;
                    }
                    try {
                        FileLock fileLock3;
                        if (fileLock2 != null && (bl2 = this.initializationAction.requiresInitialization(fileLock3 = fileLock2))) {
                            fileLock2.writeFile(new Runnable(){

                                @Override
                                public void run() {
                                    FixedSharedModeCrossProcessCacheAccess.this.initializationAction.initialize(fileLock3);
                                }
                            });
                        }
                    }
                    finally {
                        if (fileLock2 != null) {
                            fileLock2.close();
                        }
                    }
                    fileLock = this.lockManager.lock(this.lockTarget, this.lockOptions, this.cacheDisplayName);
                    bl2 = this.initializationAction.requiresInitialization(fileLock);
                }
                if (bl2) {
                    throw new CacheOpenException(String.format("Failed to initialize %s", this.cacheDisplayName), exception);
                }
            }
            this.onOpenAction.accept(fileLock);
        }
        catch (Exception exception) {
            if (fileLock != null) {
                fileLock.close();
            }
            throw UncheckedException.throwAsUncheckedException(exception);
        }
        this.fileLock = fileLock;
    }

    @Override
    public void close() {
        if (this.fileLock != null) {
            try {
                this.onCloseAction.accept(this.fileLock);
                this.fileLock.close();
            }
            finally {
                this.fileLock = null;
            }
        }
    }

    @Override
    public Runnable acquireFileLock() {
        throw this.failure();
    }

    @Override
    public <T> T withFileLock(Supplier<T> supplier) {
        throw this.failure();
    }

    protected UnsupportedOperationException failure() {
        return new UnsupportedOperationException("Cannot escalate a shared lock to an exclusive lock. This is not yet supported.");
    }
}

