/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.obfuscation;

import com.gradle.obfuscation.Keep;
import com.gradle.obfuscation.KeepMethodNames;
import com.gradle.obfuscation.KeepName;
import com.gradle.obfuscation.KeepNonTransientFieldNames;
import com.gradle.obfuscation.UnsafeObfuscationException;
import com.gradle.obfuscation.a;
import com.gradle.obfuscation.b;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.function.Supplier;

public final class ObfuscationControl {
    public static boolean retainsPropertyNames(Class<?> clazz) {
        return ObfuscationControl.isRecord(clazz) ? ObfuscationControl.hasRetention(clazz, b.RECORD_PROPERTIES) : ObfuscationControl.hasRetention(clazz, b.PROPERTIES);
    }

    private static boolean isRecord(Class<?> clazz) {
        Class<?> clazz2 = clazz.getSuperclass();
        return clazz2 != null && "java.lang.Record".equals(clazz2.getName());
    }

    public static void requireClassName(Class<?> clazz, Supplier<String> supplier) {
        ObfuscationControl.requireRetention(clazz, b.CLASS_NAME, supplier);
    }

    public static void requireClassNameAndProperties(Class<?> clazz, Supplier<String> supplier) {
        ObfuscationControl.requireRetention(clazz, b.CLASS_NAME_AND_PROPERTIES, supplier);
    }

    public static boolean isNameKept(AnnotatedElement annotatedElement) {
        AccessibleObject accessibleObject;
        if (annotatedElement.isAnnotationPresent(KeepName.class) || annotatedElement.isAnnotationPresent(Keep.class)) {
            return true;
        }
        if (annotatedElement instanceof Field) {
            accessibleObject = (Field)annotatedElement;
            if (((Field)accessibleObject).getDeclaringClass().isAnnotationPresent(KeepNonTransientFieldNames.class) && !Modifier.isTransient(((Field)accessibleObject).getModifiers())) {
                return true;
            }
            if (ObfuscationControl.isProperty((Field)accessibleObject) && ObfuscationControl.retainsPropertyNames(((Field)accessibleObject).getDeclaringClass())) {
                return true;
            }
        }
        if (annotatedElement instanceof Method) {
            accessibleObject = (Method)annotatedElement;
            if (((Method)accessibleObject).getDeclaringClass().isAnnotationPresent(KeepMethodNames.class)) {
                return true;
            }
            if (ObfuscationControl.isProperty((Method)accessibleObject) && ObfuscationControl.retainsPropertyNames(((Method)accessibleObject).getDeclaringClass())) {
                return true;
            }
        }
        return false;
    }

    private static boolean isProperty(Method method) {
        String string = method.getName();
        if (!Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        return string.startsWith("get") || string.startsWith("set") || string.startsWith("is");
    }

    private static boolean isProperty(Field field) {
        if (Modifier.isPublic(field.getModifiers())) {
            return true;
        }
        return Arrays.stream(field.getAnnotations()).anyMatch(annotation -> annotation.annotationType().getName().equals("com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonProperty"));
    }

    public static void requireMethodName(Method method, Supplier<String> supplier) {
        if (method.isAnnotationPresent(KeepName.class)) {
            return;
        }
        if (method.getDeclaringClass().isAnnotationPresent(KeepMethodNames.class)) {
            return;
        }
        throw new UnsafeObfuscationException(method, supplier);
    }

    public static boolean keepsAll(Class<?> clazz) {
        return ObfuscationControl.hasRetention(clazz, b.ALL);
    }

    public static void requireAll(Class<?> clazz, Supplier<String> supplier) {
        ObfuscationControl.requireRetention(clazz, b.ALL, supplier);
    }

    private static void requireRetention(Class<?> clazz, b b2, Supplier<String> supplier) {
        if (!ObfuscationControl.hasRetention(clazz, b2)) {
            throw new UnsafeObfuscationException(clazz, b2, supplier);
        }
    }

    private static boolean hasRetention(Class<?> clazz, b b2) {
        if (ObfuscationControl.isObfuscatable(clazz)) {
            for (a a2 : b2.a) {
                if (!a2.a(clazz)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static boolean isObfuscatable(Class<?> clazz) {
        return clazz.getName().startsWith("com.gradle.") && !clazz.getName().startsWith("com.gradle.scan.eventmodel") && !clazz.getName().startsWith("com.gradle.enterprise.api.model");
    }

    private ObfuscationControl() {
    }
}

