/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.util;

import java.math.BigInteger;
import java.util.Locale;

public final class FormatUtil {
    private static final BigInteger TWOS_COMPLEMENT_REF = BigInteger.ONE.shiftLeft(64);

    public static String formatBytes(long l2) {
        if (l2 == 1L) {
            return String.format(Locale.ROOT, "%d byte", l2);
        }
        if (l2 < 1024L) {
            return String.format(Locale.ROOT, "%d bytes", l2);
        }
        if (l2 < 0x100000L) {
            return FormatUtil.formatUnits(l2, 1024L, "KiB");
        }
        if (l2 < 0x40000000L) {
            return FormatUtil.formatUnits(l2, 0x100000L, "MiB");
        }
        if (l2 < 0x10000000000L) {
            return FormatUtil.formatUnits(l2, 0x40000000L, "GiB");
        }
        if (l2 < 0x4000000000000L) {
            return FormatUtil.formatUnits(l2, 0x10000000000L, "TiB");
        }
        if (l2 < 0x1000000000000000L) {
            return FormatUtil.formatUnits(l2, 0x4000000000000L, "PiB");
        }
        return FormatUtil.formatUnits(l2, 0x1000000000000000L, "EiB");
    }

    private static String formatUnits(long l2, long l3, String string) {
        if (l2 % l3 == 0L) {
            return String.format(Locale.ROOT, "%d %s", l2 / l3, string);
        }
        return String.format(Locale.ROOT, "%.1f %s", (double)l2 / (double)l3, string);
    }

    public static String formatBytesDecimal(long l2) {
        if (l2 == 1L) {
            return String.format(Locale.ROOT, "%d byte", l2);
        }
        if (l2 < 1000L) {
            return String.format(Locale.ROOT, "%d bytes", l2);
        }
        return FormatUtil.formatValue(l2, "B");
    }

    public static String formatValue(long l2, String string) {
        if (l2 < 1000L) {
            return String.format(Locale.ROOT, "%d %s", l2, string).trim();
        }
        if (l2 < 1000000L) {
            return FormatUtil.formatUnits(l2, 1000L, "K" + string);
        }
        if (l2 < 1000000000L) {
            return FormatUtil.formatUnits(l2, 1000000L, "M" + string);
        }
        if (l2 < 1000000000000L) {
            return FormatUtil.formatUnits(l2, 1000000000L, "G" + string);
        }
        if (l2 < 1000000000000000L) {
            return FormatUtil.formatUnits(l2, 1000000000000L, "T" + string);
        }
        if (l2 < 1000000000000000000L) {
            return FormatUtil.formatUnits(l2, 1000000000000000L, "P" + string);
        }
        return FormatUtil.formatUnits(l2, 1000000000000000000L, "E" + string);
    }

    public static long getUnsignedInt(int n2) {
        return (long)n2 & 0xFFFFFFFFL;
    }

    public static String toUnsignedString(int n2) {
        if (n2 >= 0) {
            return Integer.toString(n2);
        }
        return Long.toString(FormatUtil.getUnsignedInt(n2));
    }

    public static String toUnsignedString(long l2) {
        if (l2 >= 0L) {
            return Long.toString(l2);
        }
        return BigInteger.valueOf(l2).add(TWOS_COMPLEMENT_REF).toString();
    }

    public static String formatError(int n2) {
        return String.format(Locale.ROOT, "0x%08X", n2);
    }
}

