/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.software.os.unix.solaris;

import com.gradle.maven.extension.internal.dep.oshi.jna.platform.unix.SolarisLibc;
import com.gradle.maven.extension.internal.dep.oshi.software.common.AbstractOperatingSystem;
import com.gradle.maven.extension.internal.dep.oshi.software.os.OSProcess;
import com.gradle.maven.extension.internal.dep.oshi.software.os.OperatingSystem;
import com.gradle.maven.extension.internal.dep.oshi.software.os.unix.solaris.SolarisOSProcess;
import com.gradle.maven.extension.internal.dep.oshi.util.Constants;
import com.gradle.maven.extension.internal.dep.oshi.util.ExecutingCommand;
import com.gradle.maven.extension.internal.dep.oshi.util.GlobalConfig;
import com.gradle.maven.extension.internal.dep.oshi.util.Memoizer;
import com.gradle.maven.extension.internal.dep.oshi.util.ParseUtil;
import com.gradle.maven.extension.internal.dep.oshi.util.platform.unix.solaris.KstatUtil;
import com.gradle.maven.extension.internal.dep.oshi.util.tuples.Pair;
import com.sun.jna.platform.unix.solaris.Kstat2;
import com.sun.jna.platform.unix.solaris.LibKstat;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class SolarisOperatingSystem
extends AbstractOperatingSystem {
    private static final String VERSION;
    private static final String BUILD_NUMBER;
    private static final boolean ALLOW_KSTAT2;
    public static final boolean HAS_KSTAT2;
    private static final Supplier<Pair<Long, Long>> BOOT_UPTIME;
    private static final long BOOTTIME;

    @Override
    public String queryManufacturer() {
        return "Oracle";
    }

    @Override
    public Pair<String, OperatingSystem.OSVersionInfo> queryFamilyVersionInfo() {
        return new Pair<String, OperatingSystem.OSVersionInfo>("SunOS", new OperatingSystem.OSVersionInfo(VERSION, "Solaris", BUILD_NUMBER));
    }

    @Override
    protected int queryBitness(int n2) {
        if (n2 == 64) {
            return 64;
        }
        return ParseUtil.parseIntOrDefault(ExecutingCommand.getFirstAnswer("isainfo -b"), 32);
    }

    @Override
    public List<OSProcess> queryAllProcesses() {
        return this.queryAllProcessesFromPrStat();
    }

    private List<OSProcess> queryAllProcessesFromPrStat() {
        return this.getProcessListFromProcfs(-1);
    }

    private List<OSProcess> getProcessListFromProcfs(int n2) {
        ArrayList<OSProcess> arrayList = new ArrayList<OSProcess>();
        File[] fileArray = null;
        if (n2 < 0) {
            File object = new File("/proc");
            fileArray = object.listFiles(file -> Constants.DIGITS.matcher(file.getName()).matches());
        } else {
            File file2 = new File("/proc/" + n2);
            if (file2.exists()) {
                fileArray = new File[]{file2};
            }
        }
        if (fileArray == null) {
            return arrayList;
        }
        for (File file3 : fileArray) {
            int n3 = ParseUtil.parseIntOrDefault(file3.getName(), 0);
            SolarisOSProcess solarisOSProcess = new SolarisOSProcess(n3, this);
            if (solarisOSProcess.getState() == OSProcess.State.INVALID) continue;
            arrayList.add(solarisOSProcess);
        }
        return arrayList;
    }

    @Override
    public int getProcessId() {
        return SolarisLibc.INSTANCE.getpid();
    }

    private static long querySystemUptime() {
        if (HAS_KSTAT2) {
            return BOOT_UPTIME.get().getB();
        }
        try (KstatUtil.KstatChain kstatChain = KstatUtil.openChain();){
            LibKstat.Kstat kstat = kstatChain.lookup("unix", 0, "system_misc");
            if (kstat != null && kstatChain.read(kstat)) {
                long l2 = kstat.ks_snaptime / 1000000000L;
                return l2;
            }
        }
        return 0L;
    }

    private static long querySystemBootTime() {
        if (HAS_KSTAT2) {
            return BOOT_UPTIME.get().getA();
        }
        try (KstatUtil.KstatChain kstatChain = KstatUtil.openChain();){
            LibKstat.Kstat kstat = kstatChain.lookup("unix", 0, "system_misc");
            if (kstat != null && kstatChain.read(kstat)) {
                long l2 = KstatUtil.dataLookupLong(kstat, "boot_time");
                return l2;
            }
        }
        return System.currentTimeMillis() / 1000L - SolarisOperatingSystem.querySystemUptime();
    }

    private static Pair<Long, Long> queryBootAndUptime() {
        Object[] objectArray = KstatUtil.queryKstat2("/misc/unix/system_misc", "boot_time", "snaptime");
        long l2 = objectArray[0] == null ? System.currentTimeMillis() : (Long)objectArray[0];
        long l3 = objectArray[1] == null ? 0L : (Long)objectArray[1] / 1000000000L;
        return new Pair<Long, Long>(l2, l3);
    }

    static {
        Object object = ParseUtil.whitespaces.split(ExecutingCommand.getFirstAnswer("uname -rv"));
        VERSION = object[0];
        BUILD_NUMBER = ((String[])object).length > 1 ? object[1] : "";
        ALLOW_KSTAT2 = GlobalConfig.get("com.gradle.maven.extension.internal.dep.oshi.os.solaris.allowKstat2", true);
        object = null;
        try {
            if (ALLOW_KSTAT2) {
                object = Kstat2.INSTANCE;
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        HAS_KSTAT2 = object != null;
        BOOT_UPTIME = Memoizer.memoize(SolarisOperatingSystem::queryBootAndUptime, Memoizer.defaultExpiration());
        BOOTTIME = SolarisOperatingSystem.querySystemBootTime();
    }
}

