/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.hardware.platform.linux;

import com.gradle.maven.extension.internal.dep.oshi.driver.linux.Devicetree;
import com.gradle.maven.extension.internal.dep.oshi.driver.linux.Dmidecode;
import com.gradle.maven.extension.internal.dep.oshi.driver.linux.Lshal;
import com.gradle.maven.extension.internal.dep.oshi.driver.linux.Lshw;
import com.gradle.maven.extension.internal.dep.oshi.driver.linux.Sysfs;
import com.gradle.maven.extension.internal.dep.oshi.driver.linux.proc.CpuInfo;
import com.gradle.maven.extension.internal.dep.oshi.hardware.Baseboard;
import com.gradle.maven.extension.internal.dep.oshi.hardware.Firmware;
import com.gradle.maven.extension.internal.dep.oshi.hardware.common.AbstractComputerSystem;
import com.gradle.maven.extension.internal.dep.oshi.hardware.platform.linux.LinuxBaseboard;
import com.gradle.maven.extension.internal.dep.oshi.hardware.platform.linux.LinuxFirmware;
import com.gradle.maven.extension.internal.dep.oshi.util.Memoizer;
import java.util.function.Supplier;

final class LinuxComputerSystem
extends AbstractComputerSystem {
    private final Supplier<String> manufacturer = Memoizer.memoize(LinuxComputerSystem::queryManufacturer);
    private final Supplier<String> model = Memoizer.memoize(LinuxComputerSystem::queryModel);
    private final Supplier<String> serialNumber = Memoizer.memoize(LinuxComputerSystem::querySerialNumber);
    private final Supplier<String> uuid = Memoizer.memoize(LinuxComputerSystem::queryUUID);

    LinuxComputerSystem() {
    }

    @Override
    public String getManufacturer() {
        return this.manufacturer.get();
    }

    @Override
    public String getModel() {
        return this.model.get();
    }

    @Override
    public String getSerialNumber() {
        return this.serialNumber.get();
    }

    @Override
    public String getHardwareUUID() {
        return this.uuid.get();
    }

    @Override
    public Firmware createFirmware() {
        return new LinuxFirmware();
    }

    @Override
    public Baseboard createBaseboard() {
        return new LinuxBaseboard();
    }

    private static String queryManufacturer() {
        String string = null;
        string = Sysfs.querySystemVendor();
        if (string == null && (string = CpuInfo.queryCpuManufacturer()) == null) {
            return "unknown";
        }
        return string;
    }

    private static String queryModel() {
        String string = null;
        string = Sysfs.queryProductModel();
        if (string == null && (string = Devicetree.queryModel()) == null && (string = Lshw.queryModel()) == null) {
            return "unknown";
        }
        return string;
    }

    private static String querySerialNumber() {
        String string = null;
        string = Sysfs.queryProductSerial();
        if (string == null && (string = Dmidecode.querySerialNumber()) == null && (string = Lshal.querySerialNumber()) == null && (string = Lshw.querySerialNumber()) == null) {
            return "unknown";
        }
        return string;
    }

    private static String queryUUID() {
        String string = null;
        string = Sysfs.queryUUID();
        if (string == null && (string = Dmidecode.queryUUID()) == null && (string = Lshal.queryUUID()) == null && (string = Lshw.queryUUID()) == null) {
            return "unknown";
        }
        return string;
    }
}

