/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.driver.windows.perfmon;

import com.gradle.maven.extension.internal.dep.oshi.driver.windows.perfmon.ProcessInformation;
import com.gradle.maven.extension.internal.dep.oshi.driver.windows.perfmon.SystemInformation;
import com.gradle.maven.extension.internal.dep.oshi.util.tuples.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class LoadAverage {
    private static Thread loadAvgThread = null;
    private static double[] loadAverages = new double[]{-1.0, -1.0, -1.0};
    private static final double[] EXP_WEIGHT = new double[]{Math.exp(-0.08333333333333333), Math.exp(-0.016666666666666666), Math.exp(-0.005555555555555556)};

    public static synchronized void startDaemon() {
        if (loadAvgThread != null) {
            return;
        }
        loadAvgThread = new Thread("OSHI Load Average daemon"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Pair pair = LoadAverage.queryNonIdleTicks();
                long l2 = (Long)pair.getA();
                long l3 = (Long)pair.getB();
                long l4 = System.nanoTime();
                try {
                    Thread.sleep(2500L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                while (!Thread.currentThread().isInterrupted()) {
                    pair = LoadAverage.queryNonIdleTicks();
                    long l5 = (Long)pair.getA() - l2;
                    long l6 = (Long)pair.getB() - l3;
                    double d2 = l6 > 0L && l5 > 0L ? (double)l5 / (double)l6 : 0.0;
                    l2 = (Long)pair.getA();
                    l3 = (Long)pair.getB();
                    long l7 = SystemInformation.queryProcessorQueueLength().getOrDefault(SystemInformation.ProcessorQueueLengthProperty.PROCESSORQUEUELENGTH, 0L);
                    double[] dArray = loadAverages;
                    synchronized (dArray) {
                        if (loadAverages[0] < 0.0) {
                            Arrays.fill(loadAverages, d2);
                        }
                        for (int i2 = 0; i2 < loadAverages.length; ++i2) {
                            double[] dArray2 = loadAverages;
                            int n2 = i2;
                            dArray2[n2] = dArray2[n2] * EXP_WEIGHT[i2];
                            double[] dArray3 = loadAverages;
                            int n3 = i2;
                            dArray3[n3] = dArray3[n3] + (d2 + (double)l7) * (1.0 - EXP_WEIGHT[i2]);
                        }
                    }
                    long l8 = 5000L - (System.nanoTime() - l4) % 5000000000L / 1000000L;
                    if (l8 < 500L) {
                        l8 += 5000L;
                    }
                    try {
                        Thread.sleep(l8);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
        loadAvgThread.setDaemon(true);
        loadAvgThread.start();
    }

    private static Pair<Long, Long> queryNonIdleTicks() {
        Pair<List<String>, Map<ProcessInformation.IdleProcessorTimeProperty, List<Long>>> pair = ProcessInformation.queryIdleProcessCounters();
        List<String> list = pair.getA();
        Map<ProcessInformation.IdleProcessorTimeProperty, List<Long>> map = pair.getB();
        List<Long> list2 = map.get(ProcessInformation.IdleProcessorTimeProperty.PERCENTPROCESSORTIME);
        List<Long> list3 = map.get(ProcessInformation.IdleProcessorTimeProperty.ELAPSEDTIME);
        long l2 = 0L;
        long l3 = 0L;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if ("_Total".equals(list.get(i2))) {
                l2 += list2.get(i2).longValue();
                l3 += list3.get(i2).longValue();
                continue;
            }
            if (!"Idle".equals(list.get(i2))) continue;
            l2 -= list2.get(i2).longValue();
        }
        return new Pair<Long, Long>(l2, l3);
    }
}

