/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelEvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelMessage;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.ValueRef;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ClassUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ObjectUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Projection
extends SpelNodeImpl {
    private final boolean nullSafe;

    public Projection(boolean bl2, int n2, int n3, SpelNodeImpl spelNodeImpl) {
        super(n2, n3, spelNodeImpl);
        this.nullSafe = bl2;
    }

    @Override
    public TypedValue getValueInternal(ExpressionState expressionState) throws EvaluationException {
        return this.getValueRef(expressionState).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ValueRef getValueRef(ExpressionState expressionState) throws EvaluationException {
        TypedValue typedValue = expressionState.getActiveContextObject();
        Object object = typedValue.getValue();
        boolean bl2 = ObjectUtils.isArray(object);
        if (object instanceof Map) {
            Map map = (Map)object;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Map.Entry entry : map.entrySet()) {
                try {
                    expressionState.pushActiveContextObject(new TypedValue(entry));
                    expressionState.enterScope();
                    arrayList.add(this.children[0].getValueInternal(expressionState).getValue());
                }
                finally {
                    expressionState.popActiveContextObject();
                    expressionState.exitScope();
                }
            }
            return new ValueRef.TypedValueHolderValueRef(new TypedValue(arrayList), this);
        }
        if (object instanceof Iterable || bl2) {
            List<Object> list = object instanceof Iterable ? (List<Object>)object : Arrays.asList(ObjectUtils.toObjectArray(object));
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Class clazz = null;
            for (Object t2 : list) {
                try {
                    expressionState.pushActiveContextObject(new TypedValue(t2));
                    expressionState.enterScope("index", arrayList.size());
                    Object object2 = this.children[0].getValueInternal(expressionState).getValue();
                    if (object2 != null && bl2) {
                        clazz = this.determineCommonType(clazz, object2.getClass());
                    }
                    arrayList.add(object2);
                }
                finally {
                    expressionState.exitScope();
                    expressionState.popActiveContextObject();
                }
            }
            if (bl2) {
                if (clazz == null) {
                    clazz = Object.class;
                }
                Object object3 = Array.newInstance(clazz, arrayList.size());
                System.arraycopy(arrayList.toArray(), 0, object3, 0, arrayList.size());
                return new ValueRef.TypedValueHolderValueRef(new TypedValue(object3), this);
            }
            return new ValueRef.TypedValueHolderValueRef(new TypedValue(arrayList), this);
        }
        if (object == null) {
            if (this.nullSafe) {
                return ValueRef.NullValueRef.INSTANCE;
            }
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.PROJECTION_NOT_SUPPORTED_ON_TYPE, "null");
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.PROJECTION_NOT_SUPPORTED_ON_TYPE, object.getClass().getName());
    }

    @Override
    public String toStringAST() {
        return "![" + this.getChild(0).toStringAST() + "]";
    }

    private Class<?> determineCommonType(Class<?> clazz, Class<?> clazz2) {
        if (clazz == null) {
            return clazz2;
        }
        if (clazz.isAssignableFrom(clazz2)) {
            return clazz;
        }
        for (Class<?> clazz3 = clazz2; clazz3 != Object.class; clazz3 = clazz3.getSuperclass()) {
            if (!clazz3.isAssignableFrom(clazz)) continue;
            return clazz3;
        }
        for (Class<?> clazz4 : ClassUtils.getAllInterfacesForClassAsSet(clazz2)) {
            if (!clazz4.isAssignableFrom(clazz)) continue;
            return clazz4;
        }
        return Object.class;
    }
}

