/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.Operation;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelEvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelMessage;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Operator;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.ValueRef;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import java.math.BigDecimal;
import java.math.BigInteger;

public class OpDec
extends Operator {
    private final boolean postfix;

    public OpDec(int n2, int n3, boolean bl2, SpelNodeImpl ... spelNodeImplArray) {
        super("--", n2, n3, spelNodeImplArray);
        this.postfix = bl2;
        Assert.notEmpty(spelNodeImplArray, "Operands must not be empty");
    }

    @Override
    public TypedValue getValueInternal(ExpressionState expressionState) throws EvaluationException {
        if (!expressionState.getEvaluationContext().isAssignmentEnabled()) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.OPERAND_NOT_DECREMENTABLE, this.toStringAST());
        }
        SpelNodeImpl spelNodeImpl = this.getLeftOperand();
        ValueRef valueRef = spelNodeImpl.getValueRef(expressionState);
        TypedValue typedValue = valueRef.getValue();
        Object object = typedValue.getValue();
        TypedValue typedValue2 = typedValue;
        TypedValue typedValue3 = null;
        if (object instanceof Number) {
            Number number = (Number)object;
            typedValue3 = number instanceof BigDecimal ? new TypedValue(((BigDecimal)number).subtract(BigDecimal.ONE), typedValue.getTypeDescriptor()) : (number instanceof Double ? new TypedValue(number.doubleValue() - 1.0, typedValue.getTypeDescriptor()) : (number instanceof Float ? new TypedValue(Float.valueOf(number.floatValue() - 1.0f), typedValue.getTypeDescriptor()) : (number instanceof BigInteger ? new TypedValue(((BigInteger)number).subtract(BigInteger.ONE), typedValue.getTypeDescriptor()) : (number instanceof Long ? new TypedValue(number.longValue() - 1L, typedValue.getTypeDescriptor()) : (number instanceof Integer ? new TypedValue(number.intValue() - 1, typedValue.getTypeDescriptor()) : (number instanceof Short ? new TypedValue(number.shortValue() - 1, typedValue.getTypeDescriptor()) : (number instanceof Byte ? new TypedValue(number.byteValue() - 1, typedValue.getTypeDescriptor()) : new TypedValue(number.doubleValue() - 1.0, typedValue.getTypeDescriptor()))))))));
        }
        if (typedValue3 == null) {
            try {
                typedValue3 = expressionState.operate(Operation.SUBTRACT, typedValue2.getValue(), 1);
            }
            catch (SpelEvaluationException spelEvaluationException) {
                if (spelEvaluationException.getMessageCode() == SpelMessage.OPERATOR_NOT_SUPPORTED_BETWEEN_TYPES) {
                    throw new SpelEvaluationException(spelNodeImpl.getStartPosition(), SpelMessage.OPERAND_NOT_DECREMENTABLE, spelNodeImpl.toStringAST());
                }
                throw spelEvaluationException;
            }
        }
        try {
            valueRef.setValue(typedValue3.getValue());
        }
        catch (SpelEvaluationException spelEvaluationException) {
            if (spelEvaluationException.getMessageCode() == SpelMessage.SETVALUE_NOT_SUPPORTED) {
                throw new SpelEvaluationException(spelNodeImpl.getStartPosition(), SpelMessage.OPERAND_NOT_DECREMENTABLE, new Object[0]);
            }
            throw spelEvaluationException;
        }
        if (!this.postfix) {
            typedValue2 = typedValue3;
        }
        return typedValue2;
    }

    @Override
    public String toStringAST() {
        return this.getLeftOperand().toStringAST() + "--";
    }

    @Override
    public SpelNodeImpl getRightOperand() {
        throw new IllegalStateException("No right operand");
    }
}

