/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.http.util;

import com.gradle.maven.extension.internal.dep.org.apache.http.protocol.HTTP;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.Args;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.ByteArrayBuffer;
import java.io.Serializable;
import java.nio.CharBuffer;

public final class CharArrayBuffer
implements Serializable,
CharSequence {
    private char[] buffer;
    private int len;

    public CharArrayBuffer(int n2) {
        Args.notNegative(n2, "Buffer capacity");
        this.buffer = new char[n2];
    }

    private void expand(int n2) {
        char[] cArray = new char[Math.max(this.buffer.length << 1, n2)];
        System.arraycopy(this.buffer, 0, cArray, 0, this.len);
        this.buffer = cArray;
    }

    public void append(char[] cArray, int n2, int n3) {
        if (cArray == null) {
            return;
        }
        if (n2 < 0 || n2 > cArray.length || n3 < 0 || n2 + n3 < 0 || n2 + n3 > cArray.length) {
            throw new IndexOutOfBoundsException("off: " + n2 + " len: " + n3 + " b.length: " + cArray.length);
        }
        if (n3 == 0) {
            return;
        }
        int n4 = this.len + n3;
        if (n4 > this.buffer.length) {
            this.expand(n4);
        }
        System.arraycopy(cArray, n2, this.buffer, this.len, n3);
        this.len = n4;
    }

    public void append(String string) {
        String string2 = string != null ? string : "null";
        int n2 = string2.length();
        int n3 = this.len + n2;
        if (n3 > this.buffer.length) {
            this.expand(n3);
        }
        string2.getChars(0, n2, this.buffer, this.len);
        this.len = n3;
    }

    public void append(CharArrayBuffer charArrayBuffer, int n2, int n3) {
        if (charArrayBuffer == null) {
            return;
        }
        this.append(charArrayBuffer.buffer, n2, n3);
    }

    public void append(char c2) {
        int n2 = this.len + 1;
        if (n2 > this.buffer.length) {
            this.expand(n2);
        }
        this.buffer[this.len] = c2;
        this.len = n2;
    }

    public void append(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            return;
        }
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException("off: " + n2 + " len: " + n3 + " b.length: " + byArray.length);
        }
        if (n3 == 0) {
            return;
        }
        int n4 = this.len;
        int n5 = n4 + n3;
        if (n5 > this.buffer.length) {
            this.expand(n5);
        }
        int n6 = n2;
        for (int i2 = n4; i2 < n5; ++i2) {
            this.buffer[i2] = (char)(byArray[n6] & 0xFF);
            ++n6;
        }
        this.len = n5;
    }

    public void append(ByteArrayBuffer byteArrayBuffer, int n2, int n3) {
        if (byteArrayBuffer == null) {
            return;
        }
        this.append(byteArrayBuffer.buffer(), n2, n3);
    }

    public void clear() {
        this.len = 0;
    }

    @Override
    public char charAt(int n2) {
        return this.buffer[n2];
    }

    public char[] buffer() {
        return this.buffer;
    }

    @Override
    public int length() {
        return this.len;
    }

    public void ensureCapacity(int n2) {
        if (n2 <= 0) {
            return;
        }
        int n3 = this.buffer.length - this.len;
        if (n2 > n3) {
            this.expand(this.len + n2);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.len == 0;
    }

    public int indexOf(int n2, int n3, int n4) {
        int n5;
        int n6 = n3;
        if (n6 < 0) {
            n6 = 0;
        }
        if ((n5 = n4) > this.len) {
            n5 = this.len;
        }
        if (n6 > n5) {
            return -1;
        }
        for (int i2 = n6; i2 < n5; ++i2) {
            if (this.buffer[i2] != n2) continue;
            return i2;
        }
        return -1;
    }

    public int indexOf(int n2) {
        return this.indexOf(n2, 0, this.len);
    }

    public String substring(int n2, int n3) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Negative beginIndex: " + n2);
        }
        if (n3 > this.len) {
            throw new IndexOutOfBoundsException("endIndex: " + n3 + " > length: " + this.len);
        }
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("beginIndex: " + n2 + " > endIndex: " + n3);
        }
        return new String(this.buffer, n2, n3 - n2);
    }

    public String substringTrimmed(int n2, int n3) {
        int n4;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Negative beginIndex: " + n2);
        }
        if (n3 > this.len) {
            throw new IndexOutOfBoundsException("endIndex: " + n3 + " > length: " + this.len);
        }
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("beginIndex: " + n2 + " > endIndex: " + n3);
        }
        int n5 = n3;
        for (n4 = n2; n4 < n3 && HTTP.isWhitespace(this.buffer[n4]); ++n4) {
        }
        while (n5 > n4 && HTTP.isWhitespace(this.buffer[n5 - 1])) {
            --n5;
        }
        return new String(this.buffer, n4, n5 - n4);
    }

    @Override
    public CharSequence subSequence(int n2, int n3) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Negative beginIndex: " + n2);
        }
        if (n3 > this.len) {
            throw new IndexOutOfBoundsException("endIndex: " + n3 + " > length: " + this.len);
        }
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("beginIndex: " + n2 + " > endIndex: " + n3);
        }
        return CharBuffer.wrap(this.buffer, n2, n3);
    }

    @Override
    public String toString() {
        return new String(this.buffer, 0, this.len);
    }
}

