/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.exception;

import java.util.ArrayList;
import java.util.List;

public class ExceptionUtils {
    private static final String[] CAUSE_METHOD_NAMES = new String[]{"getCause", "getNextException", "getTargetException", "getException", "getSourceException", "getRootCause", "getCausedByException", "getNested", "getLinkedException", "getNestedException", "getLinkedCause", "getThrowable"};

    public static <T extends RuntimeException> T asRuntimeException(Throwable throwable) {
        return (T)((RuntimeException)ExceptionUtils.eraseType(throwable));
    }

    private static <R, T extends Throwable> R eraseType(Throwable throwable) throws T {
        throw throwable;
    }

    public static Throwable getRootCause(Throwable throwable) {
        List<Throwable> list = ExceptionUtils.getThrowableList(throwable);
        return list.isEmpty() ? null : list.get(list.size() - 1);
    }

    public static List<Throwable> getThrowableList(Throwable throwable) {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        while (throwable != null && !arrayList.contains(throwable)) {
            arrayList.add(throwable);
            throwable = throwable.getCause();
        }
        return arrayList;
    }

    public static boolean isChecked(Throwable throwable) {
        return throwable != null && !(throwable instanceof Error) && !(throwable instanceof RuntimeException);
    }

    public static boolean isUnchecked(Throwable throwable) {
        return throwable != null && (throwable instanceof Error || throwable instanceof RuntimeException);
    }

    public static <T extends Throwable> T throwUnchecked(T t2) {
        if (ExceptionUtils.isUnchecked(t2)) {
            throw ExceptionUtils.asRuntimeException(t2);
        }
        return t2;
    }
}

