/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io.output;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.function.IOConsumer;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.function.IOFunction;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.output.NullOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ThresholdingOutputStream
extends OutputStream {
    private static final IOFunction<ThresholdingOutputStream, OutputStream> NOOP_OS_GETTER = thresholdingOutputStream -> NullOutputStream.INSTANCE;
    private final int threshold;
    private final IOConsumer<ThresholdingOutputStream> thresholdConsumer;
    private final IOFunction<ThresholdingOutputStream, OutputStream> outputStreamGetter;
    private long written;
    private boolean thresholdExceeded;

    public ThresholdingOutputStream(int n2, IOConsumer<ThresholdingOutputStream> iOConsumer, IOFunction<ThresholdingOutputStream, OutputStream> iOFunction) {
        this.threshold = n2 < 0 ? 0 : n2;
        this.thresholdConsumer = iOConsumer == null ? IOConsumer.noop() : iOConsumer;
        this.outputStreamGetter = iOFunction == null ? NOOP_OS_GETTER : iOFunction;
    }

    protected void checkThreshold(int n2) throws IOException {
        if (!this.thresholdExceeded && this.written + (long)n2 > (long)this.threshold) {
            this.thresholdExceeded = true;
            this.thresholdReached();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.getStream().close();
    }

    @Override
    public void flush() throws IOException {
        this.getStream().flush();
    }

    protected OutputStream getOutputStream() throws IOException {
        return this.outputStreamGetter.apply(this);
    }

    @Deprecated
    protected OutputStream getStream() throws IOException {
        return this.getOutputStream();
    }

    protected void thresholdReached() throws IOException {
        this.thresholdConsumer.accept(this);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.checkThreshold(byArray.length);
        this.getStream().write(byArray);
        this.written += (long)byArray.length;
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.checkThreshold(n3);
        this.getStream().write(byArray, n2, n3);
        this.written += (long)n3;
    }

    @Override
    public void write(int n2) throws IOException {
        this.checkThreshold(1);
        this.getStream().write(n2);
        ++this.written;
    }
}

