/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.file.AccumulatorPathVisitor;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.file.Counters;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.file.PathUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.file.StandardDeleteOption;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter.FileEqualsFileFilter;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter.FileFileFilter;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter.IOFileFilter;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.function.IOConsumer;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.function.Uncheck;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileUtils {
    public static final BigInteger ONE_KB_BI = BigInteger.valueOf(1024L);
    public static final BigInteger ONE_MB_BI = ONE_KB_BI.multiply(ONE_KB_BI);
    public static final BigInteger ONE_GB_BI = ONE_KB_BI.multiply(ONE_MB_BI);
    public static final BigInteger ONE_TB_BI = ONE_KB_BI.multiply(ONE_GB_BI);
    public static final BigInteger ONE_PB_BI = ONE_KB_BI.multiply(ONE_TB_BI);
    public static final BigInteger ONE_EB_BI = ONE_KB_BI.multiply(ONE_PB_BI);
    public static final BigInteger ONE_ZB = BigInteger.valueOf(1024L).multiply(BigInteger.valueOf(0x1000000000000000L));
    public static final BigInteger ONE_YB = ONE_KB_BI.multiply(ONE_ZB);
    public static final File[] EMPTY_FILE_ARRAY = new File[0];

    public static String byteCountToDisplaySize(BigInteger bigInteger) {
        Objects.requireNonNull(bigInteger, "size");
        String string = bigInteger.divide(ONE_EB_BI).compareTo(BigInteger.ZERO) > 0 ? bigInteger.divide(ONE_EB_BI) + " EB" : (bigInteger.divide(ONE_PB_BI).compareTo(BigInteger.ZERO) > 0 ? bigInteger.divide(ONE_PB_BI) + " PB" : (bigInteger.divide(ONE_TB_BI).compareTo(BigInteger.ZERO) > 0 ? bigInteger.divide(ONE_TB_BI) + " TB" : (bigInteger.divide(ONE_GB_BI).compareTo(BigInteger.ZERO) > 0 ? bigInteger.divide(ONE_GB_BI) + " GB" : (bigInteger.divide(ONE_MB_BI).compareTo(BigInteger.ZERO) > 0 ? bigInteger.divide(ONE_MB_BI) + " MB" : (bigInteger.divide(ONE_KB_BI).compareTo(BigInteger.ZERO) > 0 ? bigInteger.divide(ONE_KB_BI) + " KB" : bigInteger + " bytes")))));
        return string;
    }

    public static String byteCountToDisplaySize(long l2) {
        return FileUtils.byteCountToDisplaySize(BigInteger.valueOf(l2));
    }

    public static void cleanDirectory(File file) throws IOException {
        IOConsumer.forAll(FileUtils::forceDelete, FileUtils.listFiles(file, null));
    }

    public static boolean deleteQuietly(File file) {
        if (file == null) {
            return false;
        }
        try {
            if (file.isDirectory()) {
                FileUtils.cleanDirectory(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return file.delete();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void forceDelete(File file) throws IOException {
        Counters.PathCounters pathCounters;
        Objects.requireNonNull(file, "file");
        try {
            pathCounters = PathUtils.delete(file.toPath(), PathUtils.EMPTY_LINK_OPTION_ARRAY, StandardDeleteOption.OVERRIDE_READ_ONLY);
        }
        catch (IOException iOException) {
            throw new IOException("Cannot delete file: " + file, iOException);
        }
        if (pathCounters.getFileCounter().get() < 1L && pathCounters.getDirectoryCounter().get() < 1L) {
            throw new FileNotFoundException("File does not exist: " + file);
        }
    }

    public static void forceMkdir(File file) throws IOException {
        FileUtils.mkdirs(file);
    }

    public static void forceMkdirParent(File file) throws IOException {
        FileUtils.forceMkdir(FileUtils.getParentFile(Objects.requireNonNull(file, "file")));
    }

    private static File getParentFile(File file) {
        return file == null ? null : file.getParentFile();
    }

    private static AccumulatorPathVisitor listAccumulate(File file, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2, FileVisitOption ... fileVisitOptionArray) throws IOException {
        boolean bl2 = iOFileFilter2 != null;
        FileEqualsFileFilter fileEqualsFileFilter = new FileEqualsFileFilter(file);
        FileEqualsFileFilter fileEqualsFileFilter2 = bl2 ? fileEqualsFileFilter.or(iOFileFilter2) : fileEqualsFileFilter;
        AccumulatorPathVisitor accumulatorPathVisitor = new AccumulatorPathVisitor(Counters.noopPathCounters(), iOFileFilter, fileEqualsFileFilter2, (path, iOException) -> FileVisitResult.CONTINUE);
        HashSet<FileVisitOption> hashSet = new HashSet<FileVisitOption>();
        if (fileVisitOptionArray != null) {
            Collections.addAll(hashSet, fileVisitOptionArray);
        }
        Files.walkFileTree(file.toPath(), hashSet, FileUtils.toMaxDepth(bl2), accumulatorPathVisitor);
        return accumulatorPathVisitor;
    }

    private static File[] listFiles(File file, FileFilter fileFilter) throws IOException {
        File[] fileArray;
        FileUtils.requireDirectoryExists(file, "directory");
        File[] fileArray2 = fileArray = fileFilter == null ? file.listFiles() : file.listFiles(fileFilter);
        if (fileArray == null) {
            throw new IOException("Unknown I/O error listing contents of directory: " + file);
        }
        return fileArray;
    }

    public static Collection<File> listFiles(File file2, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        AccumulatorPathVisitor accumulatorPathVisitor = Uncheck.apply(file -> FileUtils.listAccumulate(file, FileFileFilter.INSTANCE.and(iOFileFilter), iOFileFilter2, FileVisitOption.FOLLOW_LINKS), file2);
        return FileUtils.toList(accumulatorPathVisitor.getFileList().stream().map(Path::toFile));
    }

    private static File mkdirs(File file) throws IOException {
        if (file != null && !file.mkdirs() && !file.isDirectory()) {
            throw new IOException("Cannot create directory '" + file + "'.");
        }
        return file;
    }

    private static void requireDirectoryExists(File file, String string) throws FileNotFoundException {
        Objects.requireNonNull(file, string);
        if (!file.isDirectory()) {
            if (file.exists()) {
                throw new IllegalArgumentException("Parameter '" + string + "' is not a directory: '" + file + "'");
            }
            throw new FileNotFoundException("Directory '" + file + "' does not exist.");
        }
    }

    private static List<File> toList(Stream<File> stream) {
        return stream.collect(Collectors.toList());
    }

    private static int toMaxDepth(boolean bl2) {
        return bl2 ? Integer.MAX_VALUE : 1;
    }

    public static void touch(File file) throws IOException {
        PathUtils.touch(Objects.requireNonNull(file, "file").toPath());
    }
}

